### Requirements:
- Python <= 3.8
- PyTorch >= 1.2 (Mine 1.4.0 (CUDA 10.1))
- torchvision >= 0.4 (Mine 0.5.0 (CUDA 10.1))
- cocoapi
- yacs
- matplotlib
- GCC >= 4.9
- OpenCV

### Step-by-step installation
conda create --name scene_graph_benchmark
conda activate scene_graph_benchmark

# this installs the right pip and dependencies for the fresh python
conda install ipython
conda install scipy
conda install h5py

# scene_graph_benchmark and coco api dependencies
pip install ninja yacs cython matplotlib tqdm opencv-python overrides
conda install pytorch==1.4.0 torchvision==0.5.0 cudatoolkit=10.1 -c pytorch
export INSTALL_DIR=$PWD

# install pycocotools
cd $INSTALL_DIR
git clone https://xxxx/cocoapi.git
cd cocoapi/PythonAPI
python setup.py build_ext install

# install apex
cd $INSTALL_DIR
git clone https://xxxx/apex.git
cd apex
python setup.py install --cuda_ext --cpp_ext

# install PyTorch Detection
cd $INSTALL_DIR
cd EDAL
python setup.py build develop
unset INSTALL_DIR

# run EDAL 
# SGG MODEL: MotifPredictor VCTreePredictor TransformerPredictor
# Predicate Classification (PredCls): MODEL.ROI_RELATION_HEAD.USE_GT_BOX True MODEL.ROI_RELATION_HEAD.USE_GT_OBJECT_LABEL True
# Scene Graph Classification (SGCls): MODEL.ROI_RELATION_HEAD.USE_GT_BOX True MODEL.ROI_RELATION_HEAD.USE_GT_OBJECT_LABEL False
# Scene Graph Detection (SGDet): MODEL.ROI_RELATION_HEAD.USE_GT_BOX False MODEL.ROI_RELATION_HEAD.USE_GT_OBJECT_LABEL False
for i in range(10):
   python -m torch.distributed.launch --master_port 10001 --nproc_per_node=6 ./tools/AL_train.py --config-file "/xxx/Scene-Graph-Benchmark/configs/e2e_relation_X_101_32_8_FPN_1x.yaml" MODEL.ROI_RELATION_HEAD.USE_GT_BOX True MODEL.ROI_RELATION_HEAD.USE_GT_OBJECT_LABEL True MODEL.ROI_RELATION_HEAD.PREDICTOR MotifPredictor SOLVER.IMS_PER_BATCH 16 TEST.IMS_PER_BATCH 2 DTYPE "float16" SOLVER.MAX_ITER 16000 SOLVER.VAL_PERIOD 200 SOLVER.CHECKPOINT_PERIOD 2000 GLOVE_DIR /xxx/glove/  MODEL.PRETRAINED_DETECTOR_CKPT /xxx/checkpoints/pretrained_faster_rcnn/model_final.pth OUTPUT_DIR /xxxx/checkpoints/AL_result AL 0.01*(i+1) 
   python -m torch.distributed.launch --master_port 10001 --nproc_per_node=6 ./tools/AL_get_uncertainty.py --config-file "./xxx/configs/e2e_relation_X_101_32_8_FPN_1x.yaml" MODEL.ROI_RELATION_HEAD.USE_GT_BOX True MODEL.ROI_RELATION_HEAD.USE_GT_OBJECT_LABEL True MODEL.ROI_RELATION_HEAD.PREDICTOR MotifPredictor TEST.IMS_PER_BATCH 1 DTYPE "float16" GLOVE_DIR /xxx/glove/ OUTPUT_DIR /xxx/checkpoints/AL_result AL i+1 Uncer_mode EDL

