# Code Guide for NeurIPS 2023 Submission "Knowledge-Augmented Reasoning Distillation for Small Language Models in Knowledge-Intensive Tasks"

This repository contains the inference code for our KARD (Knowledge-Augmented Reasoning Distillation) method, allowing users to validate our experimental results with a single command.


We have included the fine-tuned Flan-T5 base and reranker checkpoints for the MedQA-USMLE dataset.


Due to file size limitations, we cannot upload the fine-tuned model checkpoint in the attachement.
Instead, you can download the checkpoint file from [this google drive link](https://drive.google.com/file/d/1jpIbwbl7VFAJT-qX18P0QcBeRMaAGtSE/view?usp=sharing).
After download is done, place `pytorch_model.bin` file inside `./checkpoints/flan-t5-base` folder.

## Minimum Requirements
- pytorch
- transformers
- pyserini

## How to Run
To run the experiment, execute the following command:

```bash
python generate_predict.py --checkpoint_path ./checkpoints/flan-t5-base --retriever_type dense --dense_retriever_path ./checkpoints/reranker/model
```

This command will initiate the inference process using the fine-tuned Flan-T5 base checkpoint and the reranker model.