#!/bin/bash

# Hyperparameter sweep for test.sh configuration
# Usage: ./run_test_sweep.sh --gpu_id <id> --server <name>

usage() {
    echo "Usage: $0 --gpu_id <id> --server <name>"
    echo "Example: $0 --gpu_id 0 --server amai"
    exit 1
}

# Parse arguments
while [[ "$#" -gt 0 ]]; do
    case $1 in
        --gpu_id) gpu_id="$2"; shift 2 ;;
        --server) server="$2"; shift 2 ;;
        *) echo "Unknown parameter: $1"; usage ;;
    esac
done

if [ -z "$gpu_id" ] || [ -z "$server" ]; then
    echo "Error: --gpu_id and --server required"
    usage
fi

sweep_config="sweep_config_test.yaml"

echo "Starting hyperparameter sweep for test.sh config"
echo "Server: $server | GPU: $gpu_id"

mkdir -p logs

# Initialize sweep
sweep_id=$(wandb sweep --project m3epi_v3_hyperparameter_tuning "$sweep_config" 2>/dev/null | grep -o 'wandb agent [^[:space:]]*' | awk '{print $3}')

if [ -z "$sweep_id" ]; then
    echo "Failed to initialize sweep"
    exit 1
fi

echo "Sweep ID: $sweep_id"

# Run sweep
export CUDA_VISIBLE_DEVICES=$gpu_id
nohup wandb agent "$sweep_id" > "logs/sweep_${server}_gpu${gpu_id}.log" 2>&1 &

pid=$!
echo "Sweep started (PID: $pid)"
echo "Monitor: tail -f logs/sweep_${server}_gpu${gpu_id}.log"