# How much correction is adequate? A Unified Bias-Aware Loss for Long-Tailed Semi-Supervised Learning

## The Code of BiAL
### This is one of the PyTorch implementations of BiAL, BiAL-CCL. The complete code will be made public after the paper is accepted.
### Partial annotations explain the implementation process and location of BiAL.

## Abstract 
Long-tailed semi-supervised learning (LTSSL) suffers from class imbalance-induced biases in both training and inference. 
Existing debiasing methods typically rely on distribution priors, which fail to capture two critical dynamic factors: the pseudo-labeling-induced shifts in effective priors and the model’s intrinsic evolving bias. 
To address this limitation, we propose Bias-Aware Loss (BiAL), a unified objective that replaces static distribution priors with the model’s current bias. 
This straightforward substitution enables BiAL to generate plug-and-play bias-aware variants of cross-entropy/logit adjustment and contrastive heads, thereby unifying prior correction across diverse network architectures and training paradigms. 
Through theoretical analysis and empirical validation, we prove that our BiAL provides a singular, unified mechanism to align training with model’s evolving state and achieves state-of-the-art performance on multiple datasets.

