import csv
import json
def read_target_csv(filename):
    data = []
    with open(filename, 'r', newline='') as csvfile:
        csv_reader = csv.DictReader(csvfile)
        for row in csv_reader:
            data.append(row['goal'])
    return data

def read_target_json(json_file):
    query=[]
    with open(json_file, 'r') as file:
        data = json.load(file)
        for item in data:
            query.append(item['query'])
    
    return query

def find_unique_elements(arr1, arr2):
    # 将两个数组转换为集合
    set1 = set(arr1)
    set2 = set(arr2)
    
    # 找出只在set1中的元素和只在set2中的元素
    unique_in_arr1 = set1 - set2
    unique_in_arr2 = set2 - set1
    
    # 合并两个集合，得到所有不同的元素
    unique_elements = unique_in_arr1.union(unique_in_arr2)
    
    return list(unique_elements)


data1=read_target_csv("")
data2=read_target_json("")

print(find_unique_elements(data1,data2))