import random

def monto_carlo_erase(sentence, p): # p是删除单词的比例，取值范围为0到1
    # 将句子拆分为单词列表
    words = sentence.split()
    # 计算要删除的单词数量
    num_words_to_delete = int(len(words) * p)
    # 在单词列表中随机选择要删除的单词的索引
    words_to_delete_indices = random.sample(range(len(words)), num_words_to_delete)
    # 删除选定的单词
    modified_sentence = [word for i, word in enumerate(words) if i not in words_to_delete_indices]
    # 将剩余的单词重新组合成句子
    modified_sentence = ' '.join(modified_sentence)
    return modified_sentence