# ECT: Consistency Models Made Easy

Pytorch implementation for Easy Consistency Tuning (ECT).

## Environment

You can run the following command to set up the Python environment through `conda`. 
Pytorch 2.3.0 and Python 3.9.18 will be installed.

```bash
conda env create -f env.yml
```

## Datasets

Prepare the dataset to the EDM's format. See a reference [here](https://github.com/NVlabs/edm?tab=readme-ov-file#preparing-datasets).

## Training

Run the following command to run ECT at batch size 128 and 200k iterations. NGPUs=2/4 is recommended. 

```bash
bash run_ecm.sh <NGPUs> <PORT> --desc bs128.200k
```

Replace NGPUs and PORT with the number of GPUs used for training and the port number for DDP sync.

## Evaluation

Run the following command to calculate FID of a pretrained checkpoint. 

```bash
bash eval_ecm.sh <NGPUs> <PORT> --resume <CKPT_PATH> 
```

## Generative Performance

### FID Evaluation

Taking the models trained by ECT as ECM, we compare ECMs' unconditional image generation capabilities with SoTA generative models on the CIFAR10 dataset, including popular diffusion models w/ advanced samplers, diffusion distillations, and consistency models on the CIFAR10 dataset.

| Method | FID | NFE | Model  | Params | Batch Size | Schedule |
| :----  | :-- | :-- |:----   | :----- | :--------- | :------- |
| Score SDE | 2.38 | 2000 | NCSN++ | 56.4M | 128 | ~1600k | 
| Score SDE-deep | 2.20 | 2000 | NCSN++ (2 $\times$ depth) | > 100M | 128 | ~1600k |
| EDM                | 2.01 | 35 | DDPM++ | 56.4M | 512 | 400k |
| PD                 | 8.34 | 1  | DDPM++ | 56.4M | 512 | 800k | 
| CD (LPIPS)         | 3.55 | 1  | NCSN++ | 56.4M | 512 | 800k | 
| CD (LPIPS)         | 2.93 | 2  | NCSN++ | 56.4M | 512 | 800k | 
| iCT-deep           | 2.51 | 1  | NCSN++ (2 $\times$ depth) | > 100M | 1024 | 400k | 
| iCT-deep           | 2.24 | 2  | NCSN++ (2 $\times$ depth) | > 100M | 1024 | 400k | 
| ECM (100k)         | 4.54 | 1  | DDPM++ | 55.7M | 128 | 100k |
| ECM (200k)         | 3.86 | 1  | DDPM++ | 55.7M | 128 | 200k |
| ECM (400k)         | 3.60 | 1  | DDPM++ | 55.7M | 128 | 400k |
| ECM (100k)         | 2.20 | 2  | DDPM++ | 55.7M | 128 | 100k | 
| ECM (200k)         | 2.15 | 2  | DDPM++ | 55.7M | 128 | 200k | 
| ECM (400k)         | 2.11 | 2  | DDPM++ | 55.7M | 128 | 400k | 

----

NOTE: We build ECT up on code from EDM (Karras et al. 2022) and have left the original copyright information. Thanks to the authors of EDM for open sourcing their code! 