import argparse

parser = argparse.ArgumentParser(description='model parameters', formatter_class=argparse.ArgumentDefaultsHelpFormatter)

parser.add_argument('--dataset', default='cifar10', type=str, help='dataset name',
                    choices=['mnist', 'cifar10', 'cifar100'])
parser.add_argument('--batch_size', default=64, type=int, help='minibatch size')
parser.add_argument('--T', default=256, type=int, help='snn simulation length')
parser.add_argument('--wd', default=5e-4, type=float, help='weight decay (L2 regularization)')
parser.add_argument('--partition', type=str, default='noniid-#label', help='the data partitioning strategy',
                    choices=['homo', 'noniid-labeldir', 'noniid-#label','iid-diff-quantity'])
parser.add_argument('--datadir', type=str, default="/data/cyn/dataset/data", help="Data directory")
parser.add_argument('--global_epochs', type=int, default=100, help='number of server epochs')
parser.add_argument('--local_epochs', type=int, default=5, help='number of local epochs')
parser.add_argument('--usebn', action='store_true', help='use batch normalization in ann')

parser.add_argument('--result', type=str, default="SNN_CIFAR10_Q2.xls", help="result dir")


args = parser.parse_args()
