import xlrd
import xlwt
from xlutils.copy import copy


def write_excel_xls(path, sheet_name, value):
    index = len(value)  # 获取需要写入数据的行数
    workbook = xlwt.Workbook()  # 新建一个工作簿
    sheet = workbook.add_sheet(sheet_name)  # 在工作簿中新建一个表格
    for i in range(0, index):
        for j in range(0, len(value[i])):
            sheet.write(i, j, value[i][j])  # 像表格中写入数据（对应的行和列）
    workbook.save(path)  # 保存工作簿
    print("xls格式表格写入数据成功！")


def write_excel_xls_append(filename, sheetname, acc, loss, loss1=-1):
    # index = len(value)  # 获取需要写入数据的行数
    workbook = xlrd.open_workbook(filename)  # 打开工作簿
    sheets = workbook.sheet_names()  # 获取工作簿中的所有表格

    inde = sheets.index(sheetname)
    # print(sheets)
    worksheet = workbook.sheet_by_index(inde)  # 获取工作簿中所有表格中的的第一个表格
    rows_old = worksheet.nrows  # 获取表格中已存在的数据的行数
    new_workbook = copy(workbook)  # 将xlrd对象拷贝转化为xlwt对象
    new_worksheet = new_workbook.get_sheet(inde)  # 获取转化后工作簿中的第一个表格

    new_worksheet.write(rows_old, 0, acc)
    new_worksheet.write(rows_old, 1, loss)
    if loss1 != -1:
        new_worksheet.write(rows_old, 2, loss1)
    new_workbook.save(filename)  # 保存工作簿
    print("xls格式表格【追加】写入数据成功！")


def read_excel_xls(path):
    workbook = xlrd.open_workbook(path)  # 打开工作簿
    sheets = workbook.sheet_names()  # 获取工作簿中的所有表格
    worksheet = workbook.sheet_by_name(sheets[0])  # 获取工作簿中所有表格中的的第一个表格
    for i in range(0, worksheet.nrows):
        for j in range(0, worksheet.ncols):
            print(worksheet.cell_value(i, j), "\t", end="")  # 逐行逐列读取数据
        print()


def write_sheet_xls(filename, sheetname):
    rb = xlrd.open_workbook(filename, formatting_info=True)
    if sheetname not in rb.sheet_names():
        workbook = copy(rb)
        workbook.add_sheet(sheetname)
        workbook.save(filename)
        workbook.save(filename)
        print('新建sheet')
