function save_spectral_channels_as_color(cube, save_folder, base_name, lam_list)
% cube: 高光谱图像 (H x W x C)，像素值范围应为 0~1
% save_folder: 要保存到的文件夹
% base_name: 如 'frame1'
% lam_list: 通道波长列表，如 [453.5, ..., 648.0]

    intensity = 5;  % 色彩强度控制
    [~, ~, C] = size(cube);
    close all;
    if ~exist(save_folder, 'dir')
        mkdir(save_folder);
    end

    for ch = 1:C
        img = cube(:, :, ch);
        name = fullfile(save_folder, sprintf('%s_channel%02d', base_name, ch));
        dispCubeAshwin(img, intensity, lam_list(ch), [], 1, 1, 0, 1, name);
    end
    close all;
end
