from enum import Enum

# convert endpoint e.g. ARROW to sign "<"
def convert_endpoint_to_sign(my_string: str, direction:str = "left") -> str:
    if my_string == "ARROW":
        if direction == "left":
            return "<"
        else:
            return ">"
    elif my_string == "TAIL":
        return "-"
    elif my_string == "BLUNT":
        return "I"
    elif my_string == "CIRCLE":
        return "o"
    elif my_string == "AST":
        return "*"
    else:
        print("Haben:", my_string)
        raise ValueError("Endpoint not recognized")

class Endpoint(Enum):
    TAIL = 0
    ARROW = 1
    BLUNT = 2
    CIRCLE = 3
    AST = 4

    def __str__(self): # returns the string representation of the endpoint
        return self.name

    def __eq__(self, other):
        return isinstance(other, Endpoint) and self.value == other.value