from .Node import Node
from .Endpoint import Endpoint, convert_endpoint_to_sign


class Edge:
    def __init__(self, node1: Node, node2: Node, end1: Endpoint, end2: Endpoint):
        self.properties = []

        if node1 is None or node2 is None:
            raise TypeError(f'Nodes must not be of NoneType. node1 = {str(node1)}, node2 = {str(node2)}')

        if end1 is None or end2 is None:
            raise TypeError(f'Endpoints must not be of NoneType. endpoint1 = {str(end1)}, endpoint2 = {str(end2)}')

        if end1 == Endpoint.ARROW and end2 == Endpoint.TAIL: # Decide whether I want to have the nodes switched (actually would require to also switch <----o)
            self.node1 = node2
            self.node2 = node1
            self.endpoint1 = end2
            self.endpoint2 = end1
        else:
            self.node1 = node1
            self.node2 = node2
            self.endpoint1 = end1
            self.endpoint2 = end2

        self.numerical_endpoint_1 = self.endpoint1.value
        self.numerical_endpoint_2 = self.endpoint2.value


    def get_node1(self) -> Node:
        return self.node1

    def get_node2(self) -> Node:
        return self.node2

    def get_endpoint1(self) -> Endpoint:
        return self.endpoint1

    def get_endpoint2(self) -> Endpoint:
        return self.endpoint2

    def get_distal_node(self, node: Node) -> Node | None:
        if self.node1 is node:
            return self.node2
        else:
            if self.node2 is node:
                return self.node1
            else:
                return None

    def get_proximal_endpoint(self, node: Node) -> Endpoint | None:
        if self.node1 is node:
            return self.endpoint1
        else:
            if self.node2 is node:
                return self.endpoint2
            else:
                return None
    
    def print_edge(self):
        print(self.node1.get_name(), convert_endpoint_to_sign(str(self.endpoint1), "left")+"--"+ convert_endpoint_to_sign(str(self.endpoint2), "right"), self.node2.get_name())