import os
import sys

FILE_DIR = os.path.dirname(os.path.realpath(__file__))
ROOT_DIR = os.path.dirname(os.path.dirname(os.path.dirname(FILE_DIR)))
RES_DIR = os.path.join(ROOT_DIR, "results")
MAIN_DATA_DIR = os.path.join(ROOT_DIR, "data")

sys.path.append(FILE_DIR)
sys.path.append(ROOT_DIR)


def get_eval_env(args):
    # Create environment
    if args.env == "spiral_env":
        from modules.envs.spiral_env.spiral_env import SpiralEnv as Env

        # Create environment
        env = Env(render=args.render)
        max_steps = 300
    elif args.env == "obstacle_env":
        from modules.envs.obstacle_env.obstacle_env import ObstacleEnv as Env

        # Create environment
        env = Env(render=args.render)
        max_steps = 100

    else:
        raise NotImplementedError


    return env, max_steps