from pathlib import Path
import io

from PIL import Image
import numpy as np

def load_image(img_file: Path) -> Image.Image:
    with open(img_file, mode='rb') as f:
        s = f.read()
    image = Image.open(io.BytesIO(s))
    # image.load()
    return image
    # array = np.asarray(image)
    # normalized_array = array.astype(np.float32) / 255 # convert to [0, 1]
    # # print("norm array shape:", normalized_array.shape)
    # # print("norm array:", normalized_array)
    # normalized_image = Image.fromarray(normalized_array, mode="RGBA")
    # return normalized_image

def resize(
    obj: Image.Image, img_size: int, target_ratio: float = 1.0,
) -> Image.Image:
    """Resizes foregrounds to `fg_target_size`% of the background area."""
    # Resize foreground to have area = fg_size**2 * background_area.
    resized_obj = obj.copy()
    # max_obj_size = max(obj.width, obj.height)
    # obj_size_ratio = max_obj_size / img_size
    # resize_factor = target_ratio / obj_size_ratio
    return resized_obj.resize(
        (
            # int(obj.width * resize_factor),
            # int(obj.height * resize_factor),
            img_size,
            img_size,
        ),
        Image.BILINEAR,
    )

def crop_image_to_square(img: Image.Image) -> Image.Image:
    """Crops image to the largest square that fits inside img.

    Crops from the top left corner.

    Args:
        img: image of type PIL image, e.g. PIL.JpegImagePlugin.JpegImageFile.

    Returns:
        Square image of same type as input image.
    """
    side_length = min(img.height, img.width)
    return img.crop((0, 0, side_length, side_length))

def calc_top_left_coordinates(
    fg: Image.Image,
    img_size: int,
    x_coord: float,
    y_coord: float,
) -> tuple[int, int]:
    """Returns coordinates of top left corner of object.

    Input coordinates are coordinates of centre of object scaled in the range
    [0, 1].

    Args:
        fg: PIL image. Foreground image.
        bg: PIL image. Background image.
        x_coord: central x-coordinate of foreground object scaled between 0 and 1.
        0 = leftmost coordinate of image, 1 = rightmost coordinate of image.
        y_coord: central y-coordinate of foreground object scaled between 0 and 1.
        0 = topmost coordinate of image, 1 = bottommost coordinate of image.
    """
    x_coord = int(x_coord * img_size)
    y_coord = int(y_coord * img_size)
    # x_coord, y_coord should be at the centre of the object.
    x_coord_start = int(x_coord - fg.width*0.5)
    y_coord_start = int(y_coord - fg.height*0.5)

    return x_coord_start, y_coord_start

def paste_fg_on_bg(
    fg: Image.Image,
    bg: Image.Image,
    x_coord: int,
    y_coord: int,
) -> Image.Image:
    """Pastes foreground on background at offset (x_coord, y_coord).

    x_coord, y_coord are floats in range [0, 1].

    Args:
        fg: foreground image of type PIL image. Examples of PIL image types include
        PIL.PngImagePlugin.PngImageFile and PIL.JpegImagePlugin.JpegImageFile.
        bg: background image of type PIL image.
        x_coord: float in range [0, 1]. x-coord offset from top left, for pasting
        foreground.
        y_coord: float in range [0, 1]. y-coord offset from top left, for pasting
        foreground.

    Returns:
        Background: PIL image (e.g. type PIL.JpegImagePlugin.JpegImageFile).
    """
    # bg_copy = bg.copy()
    bg.paste(fg, box=(x_coord, y_coord), mask=fg)
    return bg
