## What is the impact of training a model for invariance on its representations?
Questions
- If a model is trained on certain transformations with certain objects, are its (penultimate layer) representations actually invariant to those transformations on those objects?
- **OOD generalization**: Are the representations also invariant to the same transformations on different objects or even random data?
- How do the representations behave for the same objects but with different transformations? How much variance is there for a training data object with non-training transformations compared to a non-training object with training transformations?

Experiments
- Train a model to be invariant to a certain type of transformation by creating classes based on transforming an object prototype with a specific transformation.
- Perform an in-distribution distance evaluation
    - Obtain representations from the model for each class from the test set, i.e. by sampling different transformations of the model (with the training transformation) and collecting the penultimate layer representations.
    - Compute the average (median, min, max) pairwise l2 distances of the representations.
    - Compare them to a reference set of random samples from the dataset, including different objects and and transformations.
- Repeat the representation distance evaluation with object prototypes not found in the training dataset. Use objects
    - from a hold-out set derived from the 61 foreground objects
    - created randomly by sampling random color and transparency values.
