from pathlib import Path
import uuid

# import nbformat
# from nbconvert.preprocessors import ExecutePreprocessor
from nbconvert import HTMLExporter

from .upload import upload_files

def publish_notebook(
    nb_file: str,
    target_file: str,
) -> None:
    # with open(nb_file) as f:
    #     nb = nbformat.read(f, as_version=4)
        
    # execute notebook
    # ep = ExecutePreprocessor(timeout=-1, kernel_name='python3')
    # ep.preprocess(nb)
        
    html_exporter = HTMLExporter(
        template_name="classic"
    )
    # html_exporter.exclude_input = True
    # html_data, resources = html_exporter.from_notebook_node(nb)
    html_data, resources = html_exporter.from_filename(nb_file)

    # output_file = "./experiments/transforms_vs_identity/notebook.html"
    intermediate_file = Path("/tmp/") / str(uuid.uuid4())
    with open(intermediate_file, "w") as f:
        f.write(html_data)

    upload_files([str(intermediate_file)], [target_file])
