import os
from pathlib import Path
from typing import Optional, Union


DATA_DIR_KEY = "DATA_DIR"
_dataset_dir: Optional[Path] = None

def set_dataset_dir(dir: Union[str, Path]):
    global _dataset_dir
    _dataset_dir = Path(dir)

def _get_dataset_dir() -> Path:
    if _dataset_dir is not None:
        return _dataset_dir
    else:
        if DATA_DIR_KEY in os.environ:
            set_dataset_dir(os.environ[DATA_DIR_KEY])
        if _dataset_dir is not None:
            return _dataset_dir
        raise ValueError(
            "Dataset directory not set."
            f"Either set an environment variable named {DATA_DIR_KEY} "
            "to point to the directory where dataset files "
            "should be located "
            "or pass it as a Hydra configuration option under 'dirs.data'."
        )

def get_dataset_dir(
    dataset_name: str,
) -> Path:
    return _get_dataset_dir() / dataset_name
