from typing import Union
from pathlib import Path
import datetime

from pytorch_lightning import loggers as pl_loggers

from .dirs import get_logging_dir, recreate_dir


def get_tb_logger(
    task_name: Union[str, list[str]],
) -> pl_loggers.TensorBoardLogger:
    logging_dir = get_logging_dir(task_name)
    recreate_dir(logging_dir)
    return pl_loggers.TensorBoardLogger(
        str(logging_dir),
        name="",
        flush_secs=10,
    )
