from typing import Union
from utils.data import (
    DataConfig,
    create_obj2d_dataset,
    FGSource,
    BGSource,
)
from .images import show_dataset_samples

def show_samples(
    n_samples: int,
    transform_names: list[str],
    foregrounds: Union[FGSource,  list[int]],
    backgrounds: Union[BGSource, None] = None,
    sampling_seed: int = 59320,
    img_size: int = 48,
) -> None:
    data_config = DataConfig(
        sampling_seed=sampling_seed,
        img_size=img_size,
        n_training_samples=n_samples,
        n_val_samples=0,
        n_test_samples=0,
        batch_size=n_samples,
    )
    data = create_obj2d_dataset(
        data_config,
        transform_names,
        foregrounds,
        backgrounds=backgrounds,
        normalize=False,
    )
    show_dataset_samples(data, n_samples)
