from verl.utils.reward_score.coder1 import compute_score


def test_tablereason_reward():
    output = "\\boxed{aboriginal population}"
    ground_truth = "aboriginal population"
    score = compute_score(output, ground_truth)["score"]
    assert score == 1.0
    
    output = "To determine the most popular religion among all French-language workers in New Brunswick's agri-food sector, we need to compare the percentages of French-language workers belonging to each religious group across the different regions.\n\nHere are the percentages for French-language workers in each region:\n- Agricultural region 1: \n  - Catholic: 94.2%\n  - Pentecostal: 1.5%\n  - Anglican: 0.0%\n  - Presbyterian: 0.0%\n  - United Church: 0.0%\n  - Other Christian: 0.7%\n  - Buddhist, Hindu, Jewish, Muslim, and Sikh: 0.0%\n  - Other religions: 0.0%\n  - No religious affiliation: 3.3%\n\n- Agricultural region 3:\n  - Catholic: 87.2%\n  - Pentecostal: 0.5%\n  - Anglican: 0.0%\n  - Presbyterian: 0.0%\n  - United Church: 0.0%\n  - Other Christian: 1.7%\n  - Buddhist, Hindu, Jewish, Muslim, and Sikh: 1.1%\n  - Other religions: 0.0%\n  - No religious affiliation: 9.4%\n\n- Agricultural region 4:\n  - Catholic: 96.4%\n  - Pentecostal: 0.0%\n  - Anglican: 0.0%\n  - Presbyterian: 0.0%\n  - United Church: 0.0%\n  - Other Christian: 0.6%\n  - Buddhist, Hindu, Jewish, Muslim, and Sikh: 0.0%\n  - Other religions: 0.0%\n  - No religious affiliation: 2.3%\n\nFrom the data, we can see that the most common religion among French-language workers across all regions is Catholic, with percentages of 94.2%, 87.2%, and 96.4% in agricultural regions 1, 3, and 4, respectively.\n\nTherefore, the most popular religion among all French-language workers in New Brunswick's agri-food sector is \\boxed{catholic}."
    ground_truth = "catholic"
    score = compute_score(output, ground_truth)["score"]
    assert score == 1.0
    
    output = " Aboriginal population"
    ground_truth = "aboriginal population"
    score = compute_score(output, ground_truth)["score"]
    assert score == 1.0
    
    output = "To solve this problem, we first need to identify the intramural R&D expenditures for the specified states from the table, which are New York, California, Florida, South Carolina, and Connecticut. Then, we will calculate the percentage each state contributed to the total intramural R&D expenditures of $582 million.\n\nFrom the table, we can extract the following intramural R&D expenditures:\n- New York: 241,921\n- California: 55,223\n- Florida: 45,016\n- South Carolina: 22,352\n- Connecticut: 21,886\n\nNext, we calculate the total intramural R&D expenditures for these five states:\n\\[ 241,921 + 55,223 + 45,016 + 22,352 + 21,886 = 386,398 \\]\n\nNow, we need to find the percentage of the total $582 million that these five states account for:\n\\[ \\text{Percentage} = \\left( \\frac{386,398}{582,000,000} \\right) \\times 100 \\approx 0.066435 \\times 100 \\approx 6.64\\% \\]\n\nThus, the five states account for approximately 6.64% of the $582 million of intramural R&D performed by state agencies.\n\nTherefore, the answer is:\n\\boxed{6.64%}"
    ground_truth = "6.64%"
    score = compute_score(output, ground_truth)["score"]
    assert score == 1.0

    output = "\\boxed{threatening or harassing phone calls | forcible confinement, kidnapping or abduction|criminal harassment}"
    ground_truth = "forcible confinement, kidnapping or abduction|criminal harassment|threatening or harassing phone calls"
    score = compute_score(output, ground_truth)["score"]
    assert score == 1.0
    
    output = "<think>\nOkay, let's try to figure out how many appearances McIndoe made for Doncaster Rovers. First, I need to look at the table provided and find the relevant information.\n\nLooking at the table, there's a row for Doncaster Rovers. The seasons listed are 2003-04, 2004-05, 2005-06, and then a total. Under the \"league\" column, for each season, there are numbers under \"apps\" which I assume stands for appearances. \n\nFor the 2003-04 season, Doncaster Rovers have 45 apps in the third division. Then in 2004-05, they have 44 apps in League One. In 2005-06, 33 apps in League One again. The total for Doncaster Rovers is listed as 122 apps in the league. But the question is about appearances for Doncaster Rovers. However, the table also includes other competitions like national cup, league cup, and other. But the user is asking specifically about appearances for Doncaster Rovers. \n\nWait, but the question is about McIndoe's appearances. Wait, the table's columns are club, season, league, then national cup, league cup, other, and total. But the data here might be for a player's stats. But the problem is, the table's structure is a bit confusing. Let me check again.\n\nLooking at the headers: club, season, league, then three columns (division, apps, goals), then national cup, then league cup, then other, then total. Wait, the first row after the headers is \"luton town\" with 1998-99 season, second division, 22 apps, 0 goals, then national cup apps 2, goals 0, etc. So for each club and season, the data is broken down into league, national cup, league cup, other, and total. \n\nSo for Doncaster Rovers, the entries are:\n\n2003-04: third division, 45 apps, 10 goals; national cup apps 1, goals 0; league cup apps 2, goals 0; other apps 2, goals 0; total apps 50, goals 10.\n\n2004-05: league one, 44 apps, 10 goals; national cup 2 apps, 1 goal; league cup 3 apps, 1 goal; other 2 apps, 0 goals; total 51 apps, 12 goals.\n\n2005-06: league one, 33 apps, 8 goals; national cup 3 apps, 2 goals; league cup 5 apps, 3 goals; other 0 apps, 0 goals; total 41 apps, 13 goals.\n\nThen the total for Doncaster Rovers is 122 league apps, 6 national cup apps, 10 league cup apps, 4 other apps, and total 142 apps, 35 goals.\n\nBut the question is asking for the number of appearances McIndoe made for Doncaster Rovers. However, the table doesn't mention McIndoe's name anywhere. Wait, maybe the table is about a player's career? But the clubs listed are different, like Luton Town, Hereford United, etc. But the user is asking about McIndoe. Maybe the table is for McIndoe's career? But the problem is that the table doesn't have a player's name. Maybe the user is assuming that the table is about McIndoe? Or perhaps there's a mistake here.\n\nWait, the original question is \"how many appearances did mcindoe make for the doncaster rovers?\" But the table provided doesn't have a player's name. Maybe the table is for a player named McIndoe? But the table's first column is \"club\", so maybe each row is a club's stats, but that doesn't make sense. Alternatively, maybe the table is for a player's stats across different clubs. However, the way the table is structured, each row is a club-season, and the columns are for different competitions. For example, for Luton Town 1998-99, under league (second division), they have 22 apps, 0 goals. Then national cup apps 2, goals 0, etc. So this seems like a player's stats across different clubs. But the player's name isn't mentioned. Maybe the user is assuming that the table is for McIndoe, but the question is missing that info. \n\nAlternatively, maybe the user made a mistake in the question, but given the table, we have to answer based on the data provided. However, since the table doesn't mention McIndoe, but the question is about McIndoe's appearances for Doncaster Rovers, perhaps the answer is that there's no data available. But that seems unlikely. Maybe the table is for McIndoe's career, and the user is asking for that. \n\nAssuming that the table is for McIndoe's career, then for Doncaster Rovers, the total appearances would be the \"total\" column for Doncaster Rovers. Looking at the Doncaster Rovers row, the total is 142 apps. But the question is specifically about Doncaster Rovers. However, the total for Doncaster Rovers is 142 apps across all competitions (league, national cup, league cup, other). But if the question is asking for total appearances for Doncaster Rovers, then it's 142. However, if the question is asking for league appearances only, it would be 122. But the question says \"appearances\" without specifying, so it's ambiguous. However, in football stats, \"appearances\" usually refers to all competitions unless specified otherwise. \n\nBut let me check the table again. For Doncaster Rovers, the total is 142 apps. But looking at the individual seasons:\n\n2003-04: total apps 50 (league 45, national cup 1, league cup 2, other 2)\n2004-05: total 51 (44 + 2 + 3 + 2)\n2005-06: total 41 (33 + 3 +5 +0)\nAdding those: 50 + 51 +41 = 142. Yes, that matches the total. \n\nSo if the question is asking for total appearances for Doncaster Rovers, the answer is 142. However, the problem is that the table doesn't mention McIndoe. But since the user is asking about McIndoe, perhaps the table is for McIndoe's career. Maybe the user assumes that the table is for McIndoe. But that's an assumption. However, given that the question is about McIndoe and the table is provided, perhaps that's the case. \n\nAlternatively, maybe the user made a mistake in the question, but given the information, the answer would be 142. However, let me check again. The user's question is \"how many appearances did mcindoe make for the doncaster rovers?\" and the table has a row for Doncaster Rovers with total apps 142. So if we assume that the table is about McIndoe's career, then the answer is 142. But since the table's first column is \"club\", maybe it's the club's stats, not a player's. But that would make the question impossible. \n\nAlternatively, maybe the user intended the table to be for a player, and there's a formatting issue. For example, maybe the \"club\" column is the player's name, but that doesn't make sense. \n\nAlternatively, perhaps the table is for a player's stats across different clubs, and the \"club\" column is the club he played for. So for example, the first row is Luton Town, and the stats are for that player's appearances there. If that's the case, then for Doncaster Rovers, the total appearances would be 142. So the answer is 142. \n\nGiven that, I think the answer is 142. But I need to make sure. Let me check the \"career total\" row. The career total is 568 apps. For Doncaster Rovers, the total is 142. So if the question is about Doncaster Rovers, the answer is 142. \n\nBut the problem is that the table doesn't have the player's name. However, since the question is about McIndoe, and the table is provided, perhaps it's implied that the table is for McIndoe. Therefore, the answer is 142.\n</think>\n\nThe question asks for the number of appearances McIndoe made for Doncaster Rovers. Based on the table provided, the total appearances for Doncaster Rovers across all competitions (league, national cup, league cup, and other) are listed as **142**. This figure is derived from the \"total\" column under the Doncaster Rovers row, which aggregates all appearances across the 2003-04, 2004-05, and 2005-06 seasons.\n\n$$\n\\boxed{142}\n$$",
    ground_truth = "142.0"
    score = compute_score(output, ground_truth)["score"]
    assert score == 1.0
