#!/usr/bin/env python3

APARTMENT_NAME = ""  # If None, processes all apartments
EPOCHS = 1
NUM_WORKERS = 10
MAX_RETRIES = 20

MODELS = [
    "openai/gpt-image-1",
    #"google/gemini-2.5-flash-image-preview",
    "anthropic/claude-sonnet-4-20250514",
    #"anthropic/claude-opus-4-1-20250805",
    #"openai/gpt-5",
    #"openai/gpt-5-mini",
    #"openai/gpt-4o",
    #"google/gemini-2.5-pro",
    #"google/gemini-2.5-flash",
    #"grok/grok-4-0709",
]

AGENT_MODELS = [
    "anthropic/claude-opus-4-1-20250805",
    "openai/gpt-5",
]

# Prompts
RULES = """
Keep it simple, only adding exactly what's needed to comply with these rules:
1, Walls are black lines. Doors are green lines on top of a black line. (Do NOT draw door swings).
2, Ignore windows, exits and other details like furniture. The maps should be minimalistic.
3, Lines are straight (never curved) and 3 pixels wide.
4, Background MUST be completely white, not transparent.
5, Each room is completely enclosed by walls or doors with no gaps.
6, Each room has red dot (10x10px) in the middle. All enclosed areas (rooms) should have exactly 1 red dot.
7, It is important that there are no gaps in the rooms. It should be impossible to get from one red dot to another without corssing a black or green pixel.
8, Only pure red, pure black, pure white and pure green colors is allowed.
9, Include walking closets as rooms, but ignore wardrobes.
It is very important that all these rules are followed exactly.
"""
LLM_INSTR = """
Create an SVG floor plan from these apartment images. Output only SVG code in ```svg``` blocks, no explanations. Ensure the SVG is valid and well-formed XML.
"""
IMAGE_INSTR = """
Create a precise architectural floor plan from these apartment images.
"""

AGENT_INSTR = """Use the photos in /root/imgs to infer the apartment layout. Save the result as /root/output.png"""

RANDOM_LLM_INSTR = """
Create an SVG floor plan for a typical apartment. Output only SVG code in ```svg``` blocks, no explanations. Ensure the SVG is valid and well-formed XML.
"""

RANDOM_IMAGE_INSTR = """
Create a precise architectural floor plan for a typical apartment.
"""
