# Annotation Data Collection Tool for SocialNav-SUB

This repository contains a web-based annotation tool designed specifically for collecting human annotations to support the **SocialNav-SUB** dataset. The tool provides an intuitive interface to efficiently gather scene understanding data for benchmarking and evaluating robot social navigation tasks for VLMs.

---

## 🚀 Quickstart

To launch the Annotation Data Collection Tool locally, follow these steps:

### 1. Clone the Repository
```bash
git clone <repository-url>
cd <repository-name>
```

### 2. Install Dependencies
```
pip install flask jinja2 werkzeug
```

### 3. Download Prompt Data
We (temporarily) provide a google drive link to the data: https://drive.google.com/drive/folders/1wtro-DEFSqfkZ-jHgNf5sT3oDwJoggZb?usp=sharing
Afterwards, place these results within the `static/train` folder.

### 4. Running the Tool
Please launch the website like this to ensure filepaths are consistent.
```
python src/webapp.py
```
The website will be live at http://127.0.0.1:8004
This codebase was designed to be easily hosted on web servers (e.g. pythonanywhere)

### 5. Project Structure
```
src/
├── webapp.py              # Main entrypoint (Flask app)
templates/             # HTML templates
static/                # This is where the data goes (questions and samples to answer)
results/                  # Stores user responses and sessions
```

Here is an example of where data is outputted and what it looks like:
`results/{USER_ID}/{SAMPLE_ID}/Movements/answers_{TIMESTAMP}.json`
```
{"q_goal_position_begin_0": ["ahead"], "q_goal_position_end_1": ["ahead"], ...}
```

We welcome contributions.

If you find this codebase useful, please consider citing our work.
```
(Bibtex will go here with paper release)
```

