from mrunner.helpers.specification_helper import create_experiments_helper

from task_lists import task_seq_to_task_list
from defaults import combine_config_with_defaults
from utils.utils import get_script_command

run_kind = 'cl'
name = globals()['script'][:-3]

config = {}
config = combine_config_with_defaults(config, run_kind)

tasks = task_seq_to_task_list['PRETTY_MASHUP_ORD_1']
pairs = [[first, second] for first in tasks for second in tasks]

params_grid = {
  'seed': list(range(20)),
  'task_list': pairs,
}

experiments_list = create_experiments_helper(
  experiment_name=name,
  project_name='pmtest/continual-learning',
  script=get_script_command(run_kind),
  python_path='.',
  tags=[name],
  base_config=config,
  params_grid=params_grid)
