import argparse
import os
import sys

import requests
import asyncio
import concurrent.futures

from retrievers import VOCCORetriever, WebFlickrRetriever

RETRIEVERS = {'VOCCO': VOCCORetriever,
              'WebFlickr': WebFlickrRetriever}

async def get_size(url):
    response = requests.head(url)
    size = int(response.headers['Content-Length'])
    return size


def download_range(url, start, end, output):
    headers = {'Range': f'bytes={start}-{end}'}
    response = requests.get(url, headers=headers)

    with open(output, 'wb') as f:
        for part in response.iter_content(1024):
            f.write(part)


async def download(executor, url, output, chunk_size=1000000):
    loop = asyncio.get_event_loop()

    file_size = await get_size(url)
    chunks = range(0, file_size, chunk_size)

    tasks = [
        loop.run_in_executor(
            executor,
            download_range,
            url,
            start,
            start + chunk_size - 1,
            f'{output}.part{i}',
        )
        for i, start in enumerate(chunks)
    ]

    await asyncio.wait(tasks)

    with open(output, 'wb') as o:
        for i in range(len(chunks)):
            chunk_path = f'{output}.part{i}'

            with open(chunk_path, 'rb') as s:
                o.write(s.read())

            os.remove(chunk_path)


if __name__ == '__main__':
    warn("No longer implemented, please use main.py")
    quit()

    parser = argparse.ArgumentParser(description='Collate public data into usable files for loading into a Pytorch Geometric Dataset')
    parser.add_argument('-r', '--retriever', choices=['VOCCO'], required=True,
                        help='retriever to be used')
    parser.add_argument('-v', '--verbose', action='store_true',
                        help='display progress bars')
    parser.add_argument('-d', '--debug', action='store_true',
                        help='display exceptions and error messages')
    parser.add_argument('-p', '--process', action='store_true',
                        help='crop and scale images')
    parser.add_argument('-u', '--undirected', action='store_true',
                        help='create an undirected graph')
    parser.add_argument('-f', '--fromFiles', action='store_true',
                        help='Load indices from previously generated XML files, overrides verbose option')
    parser.add_argument('--statistics', action='store_true',
                        help='show statistics about the generated data')
    parser.add_argument('-o', '--outputpath', nargs='?', required='--process' in sys.argv,
                        help='folder where output files are stored')
    parser.add_argument('-i', '--inputpath', nargs='?',
                        help='unpacked raw data folder')
    parser.add_argument('-a', '--adjacency', nargs='?',
                        help='pre-existing adjacency matrix to adjust based on available data')
    parser.add_argument('--sep', nargs='?', required='--adjacency' in sys.argv, type=str,
                        help='separator for adjacency file')
    parser.add_argument('-s', '--size', nargs='?', required='--process' in sys.argv, type=int,
                        help='cropped image size')
    parser.add_argument('--download', nargs='?',
                        help='download raw data')
    args = parser.parse_args()

    if args.download:
        URL = args.download
        OUTPUT = os.path.join(args.inputpath, URL.split('/')[-1])
        executor = concurrent.futures.ThreadPoolExecutor(max_workers=32)
        loop = asyncio.get_event_loop()

        try:
            loop.run_until_complete(
                download(executor, URL, OUTPUT)
            )
        finally:
            loop.close()

        extracted = OUTPUT
        if OUTPUT.split('.')[-1] == "gz":
            extract = "gunzip " + OUTPUT
            os.system(extract)
            extracted = str(OUTPUT.split('.')[:-1])

        if extracted.split('.')[-1] == "tar":
            extract = "tar -x{verbose}f {file} -C {destination}".format(verbose='v' if args.verbose else '',
                                                                        file=extracted,
                                                                        destination=args.inputpath)
            os.system(extract)

    data_retriever = RETRIEVERS[args.retriever](args)
    data_retriever.start()

