import os
import re
import flickrapi
import xml.etree.ElementTree as ET


API_KEY = os.environ['FLICKR_API_KEY']
API_SECRET = os.environ['FLICKR_API_SECRET']

FLICKR = flickrapi.FlickrAPI(API_KEY,
                             API_SECRET,
                             format='etree')


class Retriever:
    @staticmethod
    def process_annotation(filename):
        raise NotImplementedError

    @staticmethod
    def get_url(idx):
        try:
            urls = FLICKR.photos.getSizes(api_key=API_KEY, photo_id=idx)
            return urls.find('sizes').find('size').get('source')
        except:
            return None


class NUSWideRetriever(Retriever):
    @staticmethod
    def process_annotation(filename, valid_ids):
        ids = []
        labels = {}

        with open(filename) as file:
            for line in file:
                tokens = line.split('.')[0]
                tokens = tokens.split('\\')
                if len(tokens) > 1:
                    label = tokens[0]
                    idx = re.split('_', tokens[1])[1]

                    if int(idx) in valid_ids:
                        ids.append(idx)
                        labels[idx] = label

        return ids, labels


class WebFlickrRetriever(Retriever):
    @staticmethod
    def process_annotation(filename, valid_ids):
        file = open(filename)

        ids = []
        labels = {}

        line = file.readline()
        block = ""
        for line in file:
            block += line

            if line == "</photo>\n":
                photo = ET.fromstring(block)
                block = ""

                idx = photo.get('id')

                if int(idx) in valid_ids:
                    tags = []
                    label = photo.find('labels')
                    if label:
                        for tag in label.findall('label'):
                            tags.append(tag.text)

                    if len(tags) > 0:
                        labels[idx] = tags
                        ids.append(idx)

        return ids, labels

