from .GAT import GAT
from .GraphSAGE import GraphSAGE
from .ClusterGCN import ClusterGCN
from .Net import Net
from .EFG import EFG
from .ResNetGNN import resnetGNN, resnet50GNN
from .ResNetEFG import resnet18EFG, resnet50EFG
from .CifarNetEFG import CifarNetEFG
from .TrainedResNet import resnet50, resnet18
from .TrainedroBERTa import RoBERTa
from .vgg import vgg16


models = {
    "GAT": GAT,
    "GraphSAGE": GraphSAGE,
    "ClusterGCN": ClusterGCN,
    "Net": Net,
    "EFG": EFG,
    "ResNetGNN": resnetGNN,
    "ResNet50GNN": resnet50GNN,
    "ResNetEFG": resnet50EFG,
    "ResNet18EFG": resnet18EFG,
    "ResNet50EFG": resnet50EFG,
    "ResNet50": resnet50,
    "ResNet18": resnet18,
    "CifarNetEFG": CifarNetEFG,
    "RoBERTa": RoBERTa,
    "VGG16": vgg16,
}

