from torch_geometric.nn import GATConv, SAGEConv
from .GCNConv import GCNConv
from .GAT2Conv import GAT2Conv
from .EFATConv import EFATConv
from .EFATPool import EFATPool
from .EFATDense import EFATDense
from .EFATLinear import EFATLinear

layers = {
    "SAGEConv": SAGEConv,
    "GATConv": GATConv,
    "GCNConv": GCNConv,
    "GAT2Conv": GAT2Conv,
    "EFATConv": EFATConv,
    "EFATPool": EFATPool,
    "EFATDense": EFATDense,
    "EFATLinear": EFATLinear,
}

