"""
Define constants.
"""
EMB_INIT_RANGE = 1.0

# vocab
PAD_TOKEN = '<PAD>'
PAD_ID = 0
UNK_TOKEN = '<UNK>'
UNK_ID = 1

VOCAB_PREFIX = [PAD_TOKEN, UNK_TOKEN]



POS_TO_ID = {PAD_TOKEN: 0, UNK_TOKEN: 1, 'NNP': 2, 'NN': 3, 'IN': 4, 'DT': 5, ',': 6, 'JJ': 7, 'NNS': 8, 'VBD': 9, 'CD': 10, 'CC': 11, '.': 12, 'RB': 13, 'VBN': 14, 'PRP': 15, 'TO': 16, 'VB': 17, 'VBG': 18, 'VBZ': 19, 'PRP$': 20, ':': 21, 'POS': 22, '\'\'': 23, '``': 24, '-RRB-': 25, '-LRB-': 26, 'VBP': 27, 'MD': 28, 'NNPS': 29, 'WP': 30, 'WDT': 31, 'WRB': 32, 'RP': 33, 'JJR': 34, 'JJS': 35, '$': 36, 'FW': 37, 'RBR': 38, 'SYM': 39, 'EX': 40, 'RBS': 41, 'WP$': 42, 'PDT': 43, 'LS': 44, 'UH': 45, '#': 46}


DEPREL_TO_ID = {PAD_TOKEN: 0, UNK_TOKEN: 1, 'punct': 2, 'compound': 3, 'case': 4, 'nmod': 5, 'det': 6, 'nsubj': 7, 'amod': 8, 'conj': 9, 'dobj': 10, 'ROOT': 11, 'cc': 12, 'nmod:poss': 13, 'mark': 14, 'advmod': 15, 'appos': 16, 'nummod': 17, 'dep': 18, 'ccomp': 19, 'aux': 20, 'advcl': 21, 'acl:relcl': 22, 'xcomp': 23, 'cop': 24, 'acl': 25, 'auxpass': 26, 'nsubjpass': 27, 'nmod:tmod': 28, 'neg': 29, 'compound:prt': 30, 'mwe': 31, 'parataxis': 32, 'root': 33, 'nmod:npmod': 34, 'expl': 35, 'csubj': 36, 'cc:preconj': 37, 'iobj': 38, 'det:predet': 39, 'discourse': 40, 'csubjpass': 41}



#atis
LABEL_TO_ID = {'E-toloc.airport_name': 0, 'B-arrive_date.day_number': 1, 'E-arrive_time.time_relative': 2, 'O': 3, 'I-depart_time.time_relative': 4, 'S-depart_time.time': 5, 'B-economy': 6, 'I-city_name': 7, 'E-meal_code': 8, 'E-arrive_time.time': 9, 'I-arrive_time.time': 10, 'S-time': 11, 'S-restriction_code': 12, 'E-depart_time.time_relative': 13, 'I-flight_stop': 14, 'S-arrive_time.period_of_day': 15, 'S-depart_time.period_mod': 16, 'S-stoploc.airport_name': 17, 'B-depart_date.day_number': 18, 'E-depart_date.day_name': 19, 'E-depart_time.start_time': 20, 'E-class_type': 21, 'B-arrive_time.time': 22, 'B-return_date.date_relative': 23, 'S-depart_date.year': 24, 'B-round_trip': 25, 'I-stoploc.city_name': 26, 'S-state_name': 27, 'E-flight_time': 28, 'S-arrive_time.period_mod': 29, 'B-meal_description': 30, 'S-flight_mod': 31, 'B-arrive_time.time_relative': 32, 'I-flight_mod': 33, 'E-round_trip': 34, 'E-city_name': 35, 'I-return_date.date_relative': 36, 'B-arrive_time.end_time': 37, 'S-connect': 38, 'S-depart_date.today_relative': 39, 'S-return_time.period_mod': 40, 'S-round_trip': 41, 'B-depart_date.day_name': 42, 'B-depart_time.time': 43, 'S-airline_name': 44, 'B-class_type': 45, 'S-depart_date.date_relative': 46, 'E-arrive_time.end_time': 47, 'S-flight_number': 48, 'S-airline_code': 49, 'S-fromloc.state_name': 50, 'B-restriction_code': 51, 'B-depart_date.today_relative': 52, 'S-state_code': 53, 'S-arrive_date.day_number': 54, 'S-arrive_date.day_name': 55, 'B-airport_name': 56, 'S-depart_date.day_number': 57, 'B-fare_amount': 58, 'S-depart_time.time_relative': 59, 'S-class_type': 60, 'S-toloc.country_name': 61, 'B-return_date.day_number': 62, 'S-time_relative': 63, 'E-transport_type': 64, 'E-return_date.day_number': 65, 'S-return_time.period_of_day': 66, 'E-meal_description': 67, 'S-cost_relative': 68, 'S-toloc.airport_code': 69, 'B-transport_type': 70, 'S-depart_date.month_name': 71, 'I-today_relative': 72, 'S-fromloc.airport_code': 73, 'E-arrive_time.period_of_day': 74, 'S-economy': 75, 'I-mod': 76, 'S-toloc.city_name': 77, 'B-time': 78, 'E-flight_stop': 79, 'S-return_date.month_name': 80, 'E-arrive_time.start_time': 81, 'I-transport_type': 82, 'S-depart_time.start_time': 83, 'S-fromloc.city_name': 84, 'S-depart_time.period_of_day': 85, 'B-flight_time': 86, 'S-fromloc.airport_name': 87, 'S-stoploc.city_name': 88, 'I-arrive_time.time_relative': 89, 'E-toloc.state_name': 90, 'B-depart_time.period_of_day': 91, 'S-arrive_time.start_time': 92, 'S-return_date.day_name': 93, 'E-arrive_date.day_number': 94, 'E-airport_name': 95, 'S-return_date.day_number': 96, 'S-day_number': 97, 'S-meal': 98, 'I-airline_name': 99, 'S-arrive_time.time': 100, 'E-fare_basis_code': 101, 'I-depart_time.time': 102, 'S-stoploc.state_code': 103, 'E-depart_time.period_of_day': 104, 'S-meal_description': 105, 'I-toloc.airport_name': 106, 'B-fromloc.airport_name': 107, 'E-depart_time.end_time': 108, 'S-period_of_day': 109, 'B-depart_time.end_time': 110, 'S-fare_basis_code': 111, 'B-fromloc.state_name': 112, 'B-meal_code': 113, 'S-or': 114, 'B-stoploc.city_name': 115, 'B-fare_basis_code': 116, 'E-mod': 117, 'B-flight_stop': 118, 'B-toloc.state_name': 119, 'B-cost_relative': 120, 'I-meal_code': 121, 'E-stoploc.city_name': 122, 'S-city_name': 123, 'B-flight_mod': 124, 'S-arrive_date.date_relative': 125, 'E-toloc.city_name': 126, 'B-depart_time.time_relative': 127, 'E-fromloc.city_name': 128, 'S-arrive_date.month_name': 129, 'E-flight_mod': 130, 'B-toloc.airport_name': 131, 'B-toloc.city_name': 132, 'I-fromloc.airport_name': 133, 'B-city_name': 134, 'E-fromloc.airport_name': 135, 'B-arrive_time.start_time': 136, 'S-arrive_time.end_time': 137, 'B-today_relative': 138, 'I-flight_time': 139, 'S-depart_date.day_name': 140, 'B-depart_time.start_time': 141, 'S-meal_code': 142, 'S-flight_days': 143, 'S-arrive_date.today_relative': 144, 'S-toloc.state_name': 145, 'S-month_name': 146, 'B-return_date.today_relative': 147, 'S-fare_amount': 148, 'E-airline_name': 149, 'S-return_date.date_relative': 150, 'E-depart_date.today_relative': 151, 'I-airport_name': 152, 'S-mod': 153, 'E-fare_amount': 154, 'I-toloc.city_name': 155, 'S-airport_code': 156, 'S-days_code': 157, 'E-return_date.today_relative': 158, 'S-arrive_time.time_relative': 159, 'S-depart_time.end_time': 160, 'E-today_relative': 161, 'I-depart_date.today_relative': 162, 'S-flight_time': 163, 'S-flight_stop': 164, 'E-return_date.date_relative': 165, 'E-fromloc.state_name': 166, 'I-return_date.today_relative': 167, 'S-fromloc.state_code': 168, 'S-toloc.state_code': 169, 'E-depart_time.time': 170, 'E-depart_date.day_number': 171, 'B-fromloc.city_name': 172, 'S-day_name': 173, 'I-fromloc.city_name': 174, 'B-mod': 175, 'I-depart_date.day_name': 176, 'E-cost_relative': 177, 'E-restriction_code': 178, 'E-time': 179, 'S-today_relative': 180, 'B-airline_name': 181, 'E-economy': 182, 'B-arrive_time.period_of_day': 183, 'S-aircraft_code': 184, 'S-transport_type': 185}

INFINITY_NUMBER = 1e12
#atis
train_sample = {'O': 32697, 'fromloc.city_name': 4522, 'toloc.city_name': 4948, 'depart_date.day_name': 795, 'depart_time.period_of_day': 532, 'flight_time': 89, 'depart_time.time': 609, 'cost_relative': 344, 'fare_amount': 90, 'depart_date.today_relative': 88, 'city_name': 254, 'stoploc.city_name': 264, 'toloc.airport_code': 18, 'depart_time.time_relative': 295, 'class_type': 359, 'depart_date.date_relative': 77, 'airline_name': 987, 'arrive_time.time_relative': 167, 'arrive_time.time': 322, 'depart_time.start_time': 32, 'depart_time.end_time': 36, 'round_trip': 559, 'toloc.state_name': 83, 'depart_date.day_number': 458, 'depart_date.month_name': 333, 'mod': 28, 'fare_basis_code': 69, 'transport_type': 59, 'flight_mod': 295, 'fromloc.airport_name': 182, 'meal': 38, 'toloc.state_code': 74, 'meal_description': 52, 'return_date.month_name': 4, 'return_date.day_number': 5, 'airline_code': 110, 'depart_time.period_mod': 39, 'flight_stop': 160, 'arrive_time.period_of_day': 59, 'fromloc.airport_code': 11, 'arrive_date.month_name': 42, 'arrive_date.day_number': 48, 'time': 3, 'or': 59, 'arrive_date.day_name': 81, 'economy': 37, 'flight_number': 73, 'flight_days': 33, 'toloc.airport_name': 81, 'state_code': 8, 'arrive_time.start_time': 27, 'arrive_time.end_time': 37, 'fromloc.state_name': 46, 'arrive_date.date_relative': 10, 'depart_date.year': 23, 'return_date.date_relative': 10, 'airport_code': 28, 'aircraft_code': 26, 'fromloc.state_code': 42, 'connect': 35, 'restriction_code': 30, 'airport_name': 79, 'toloc.country_name': 3, 'days_code': 3, 'day_name': 5, 'period_of_day': 5, 'today_relative': 5, 'stoploc.state_code': 3, 'arrive_time.period_mod': 3, 'meal_code': 10, 'state_name': 2, 'stoploc.airport_name': 1, 'arrive_date.today_relative': 2, 'time_relative': 1, 'return_time.period_of_day': 3, 'return_time.period_mod': 2, 'month_name': 2, 'day_number': 2, 'return_date.today_relative': 3, 'return_date.day_name': 1}
