from keras.utils import np_utils
import numpy as np
import math
import matplotlib.pyplot as plt
import matplotlib.animation as animation
import sys
import time
from multiprocessing import Pool

import pandas as pd 
from tqdm import tqdm,trange
from sklearn.metrics.cluster import normalized_mutual_info_score
from scipy.cluster.hierarchy import dendrogram, linkage 
from datetime import datetime
sys.path.append('CGCP')
sys.path.append('algorithm')
sys.path.append('high dimensional CGCP')

#problems
#from ChunkTest import *
from OverlapChunkTest1 import *
from OverlapChunkTest2 import *
from LongChunkTest import *
from FixedChunkTest import *
from GraphWalkTest import *

#neurons
from MRIL import *
from SyncMap import *
from Sigma import *
from VAE import *
from modularity_max import *
#algorithm_list ={
#    'SyncMap':SyncMap,
#    'Sigma':Sigma,
#    'VAE':VAE,
#    'MRIL':MRIL,
#    'modularity':modularity_max
#}
muti_logic=False
#variable can change------------------
algorithm='VAE'
sequence_length = 100000
time_delay = 10
#---------------------------------
env=GraphWalkTest(10,"CGCP/graph.dot")
input_sequence, input_class = env.getSequence(sequence_length)
output_size=env.output_size
if algorithm =='SyncMap':
    number_of_nodes= output_size
    adaptation_rate= 0.001*output_size
    map_dimensions= 3
    algorithm_class = SyncMap(number_of_nodes, map_dimensions, adaptation_rate)
if algorithm =='Sigma':
    number_of_nodes= output_size
    adaptation_rate= 0.001*output_size
    map_dimensions= 2
    algorithm_class = Sigma(number_of_nodes, map_dimensions, adaptation_rate)
if algorithm =='VAE':
    input_size= output_size
    latent_dim= 3
    timesteps= 100
    algorithm_class = VAE(input_size, latent_dim, timesteps)           
if algorithm =='modularity':
    algorithm_class=modularity_max()

neuron_group = algorithm_class
neuron_group.input(input_sequence)
print(neuron_group.evaluation(env.trueLabel()))
print('------------finish----------')

