# Path integral importance sampling code

---

A Dockerfile is provided with all dependencies required to run the experiments.
The image can be built using
```
docker build -t sde-pathint .
```
and the program can be run using
```
docker run -dit --gpus all -v $(pwd)/.data:/workspace/.data sde-pathint python -m pathint METHOD
```
where `METHOD` is one of `pi` or `adj`.

This will generate the observation data set and train a neural net using the
appropriate algorithm and save the data set, model checkpoint and training stats
under the directory `.data/`.

This command will not generate the plots. The plots can be generated using the command
```
docker run -dit --rm -v $(pwd)/.data:/workspace/.data sde-pathint python -m pathint.plotting
```

The gradient variance experiment can be performed similarly with 
```
... python -m pathint.chickenpox
```
and the GP experiment with 
```
... python -m pathint.gp
```
