# Codebase for the synthetic experiments of WSGM

## Gaussian experiments

The Gaussian experiments are in the notebook `gaussian_covariances.ipynb`. 

## Experiments on $\varphi^4$

The training data are 10k samples of critical $\varphi^4$ fields. They should be saved as $(10000,1,L,L)$ tensors arrays in Torch's `.pt` format under the `save/data` directory. They were generated using the C++ code contained in `data/phi4sampling`. 

Our score models and functions for sampling diffusions/backward diffusions are in `models/diffusion.py`. 

The training of a model on a GPU can be done using `python training.py`. The training arguments are inside the man function. The training parameters/hyperparameters are saved under `save/exp/phi4_{L}_{T}_{N}_pot{P}.pt` where $L$ is the size, T is the type of model (U = non-conditional, M = multiscale), N is the number of diffusion steps and P is the type of potential (G = gaussian, Q = Quartic, A = adaptative, hyperparameters are in the arguments). 

Sampling experiments are inside the `sampling.ipynb` notebook. 