import numpy as np

def caravan_testtrain_conv(x):
    if x == b'train':
        return 0
    else:
        return 1

def get_caravan_lr_data(filename='./Datasets/caravan-insurance-challenge.csv'):
    full_data = np.loadtxt(filename, converters={0: lambda x: caravan_testtrain_conv(x)}, delimiter=',', skiprows=1)
    train_data = full_data[full_data[:,0] == 0]
    return train_data[:,1:-1], train_data[:, -1]
    
    
def get_ripley_lr_data(filename='./Datasets/ripley.csv'):
    full_data = np.loadtxt(filename, skiprows=1)
    return full_data[:, 0:-1], full_data[:, -1]


def get_germancredit_lr_data(filename='./Datasets/SouthGermanCredit.asc'):
    full_data = np.loadtxt(filename, skiprows=1)
    return full_data[:, 0:-1], full_data[:, -1]

def get_australiancredit_lr_data(filename='./Datasets/australian.dat'):
    full_data = np.loadtxt(filename, skiprows=1)
    return full_data[:, 0:-1], full_data[:, -1]

def get_heart_lr_data(filename='./Datasets/heart.csv'):
    full_data = np.loadtxt(filename, skiprows=1, delimiter=',')
    return full_data[:, 0:-1], full_data[:, -1]

def get_pima_lr_data(filename='./Datasets/diabetes.csv'):
    full_data = np.loadtxt(filename, skiprows=1, delimiter=',')
    return full_data[:, 0:-1], full_data[:, -1]
