using UnityEngine;

public class CameraCoordTest : MonoBehaviour
{
    public Camera targetCamera;      // 指定要测试的相机
    public Vector3 testPointCam1 = new Vector3(0, 0, 1);  // 相机坐标系下的点 (前方1米)
    public Vector3 testPointWorld2 = new Vector3(0, 0, 0); 

    private Vector3 testPointWorld1;
    private Vector3 testPointCam2;
    private Vector3 recoverPoint1;
    private Vector3 recoverPoint2;

    void Start()
    {
        if (targetCamera == null) return;

        // 1. 获取相机的世界位置和旋转
        Vector3 camPos = targetCamera.transform.position;
        Quaternion camRot = targetCamera.transform.rotation;

        // 2. 相机坐标点 → 世界坐标
        testPointWorld1 = camRot * testPointCam1 + camPos;
        Debug.Log($"相机坐标系下的点{testPointCam1} 转换到世界坐标系下为: {testPointWorld1}");

        // 3. 世界坐标 -> 相机坐标
        recoverPoint1 = Quaternion.Inverse(camRot) * (testPointWorld1 - camPos);

        Debug.Log($"从世界坐标反推会相机坐标: {recoverPoint1}");


        // 2. 世界坐标 -> 相机坐标
        testPointCam2 = Quaternion.Inverse(camRot) * (testPointWorld2 - camPos);
        Debug.Log($"世界坐标系下的点{testPointWorld2} 转换到相机坐标系下为: {testPointCam2}");

        // 3. 相机坐标 -> 世界坐标
        recoverPoint2 = camRot * testPointCam2 + camPos;
        Debug.Log($"从相机坐标反推到世界坐标: {recoverPoint2}");
    }

    void OnDrawGizmos()
    {
        if (targetCamera == null) return;

        // // 相机位置画蓝色球
        // Gizmos.color = Color.blue;
        // Gizmos.DrawSphere(targetCamera.transform.position, 0.05f);

        // 转换后的点画红色球
        Gizmos.color = Color.red;
        Gizmos.DrawSphere(testPointWorld1, 0.1f);

        // 另一个转换后的点画绿色球
        Gizmos.color = Color.green;
        Gizmos.DrawSphere(testPointWorld2, 0.1f);

        // 连线
        Gizmos.color = Color.yellow;
        Gizmos.DrawLine(testPointWorld1, testPointWorld2);
    }
}