using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CameraIntrinsicsExporter : MonoBehaviour
{
    public Camera cam;
    // private Dynamic controller;
    public int width;
    public int height;

    void Start()
    {
        int W = width;
        int H = height;

        // Unity 的 fieldOfView 是垂直FOV（度），要转成弧度
        float fovY_rad = cam.fieldOfView * Mathf.Deg2Rad;

        // fy = H / (2 * tan(FOVy/2))
        float fy = H / (2.0f * Mathf.Tan(fovY_rad / 2.0f));
        // fx 按宽高比推
        float fx = fy * ((float)W / H);

        float cx = W / 2.0f;
        float cy = H / 2.0f;

        Debug.Log($"Unity Camera Intrinsics (fx, fy, cx, cy): {fx}, {fy}, {cx}, {cy}");
    }
}
