using UnityEngine;
using WebSocketSharp;

public class WebSocketTest : MonoBehaviour
{
    WebSocket ws;

    void Start()
    {
        string serverUrl = "ws://127.0.0.1:8765";
        ws = new WebSocket(serverUrl);

        ws.OnOpen += (sender, e) =>
        {
            Debug.Log("✅ 已连接服务器");
            ws.Send("Hello from Unity!");
        };

        ws.OnMessage += (sender, e) =>
        {
            Debug.Log("📩 收到服务器消息: " + e.Data);
        };

        ws.OnError += (sender, e) =>
        {
            Debug.LogError("❌ WebSocket 错误: " + e.Message);
        };

        ws.OnClose += (sender, e) =>
        {
            Debug.Log("🔌 WebSocket 已关闭");
        };

        ws.Connect(); // 注意：要在绑定事件之后调用
    }

    void OnDestroy()
    {
        if (ws != null && ws.IsAlive)
            ws.Close();
    }
}