#!/usr/bin/env python3 3.7.4 project3 env
# -*- coding: utf-8 -*-
"""
Run all scripts necessary to reproduce the paper.
"""

import sys

sys.path.append("modules")


import setup_parameters
import setup_OFC_network
import adaptation_learning
from pathlib import Path

#%%

def run(opts):

    savname = opts.out_dir
    if opts.fb_density == 0 and opts.task == "random":
        tm_savname = (
            "./results/{experiment-timestamp}_no_delay_2k_b2b_large_batch_n/0000_fb_freeze_False__delay_0__go_to_peak_50__vel_10.0__error_detach_False__nlayers_1__dataset_name_Reaching__task_random__fb_density_0/"
            + str(opts.run_id)
            + "/"
        )
    elif opts.fb_density == 1 and opts.task == "random":
        tm_savname = (
            "./results/{experiment-timestamp}_no_delay_2k_b2b_large_batch/0003_fb_freeze_False__delay_0__go_to_peak_50__vel_10.0__error_detach_False__nlayers_1__dataset_name_Reaching__task_random_pushed__fb_density_1/"
            + str(opts.run_id)
        )


    if opts.learning_algorithm not in ["rflo", "fed"]:
        opts.record_local_gradients = False

    if opts.fb_density == 0 and opts.learning_algorithm in ["rflo", "fed"]:
        opts.learning_algorithm += "_t"  

    adaptation_learning.main(
        savname,
        opts.learning_algorithm,
        learning_rate,
        opts.fb_in,
        bp_opt=opts.bp_opt,
        tm_savname=tm_savname,
        ntrials=opts.ntrials,
        rot_phi=opts.rot_phi,
        batch_size=opts.batch_size,
    )


def main():
    from liftoff import parse_opts

    run(parse_opts())


if __name__ == "__main__":
    main()
