#!/bin/bash
#SBATCH --job-name=optuna
#SBATCH --nodelist=sarek17
#SBATCH --output=./logs/%A_%a.out
#SBATCH --error=./logs/%A_%a.err
#SBATCH --array=1-4
#SBATCH --time=24:00:00
#SBATCH --ntasks=1
#SBATCH --mem=60G
#SBATCH --gres=gpu:1

sleep $((RANDOM%30+1))

pwd
nvidia-smi
source ~/.bashrc
source activate research

python supervised.py \
--name optuna --n_trials 250 \
--data mnist \
--input_zca --output_pool 2 \
--n_layers 3 --layer_pool none \
--rescale_features \
--max_n_subspaces 64 --max_subspace_dim 16 \
--batch_size 256 --n_epochs 1 --chunks_per_update 2 \
--verbose 1 \
--n_classes 10 --n_labels -1 \
--label_seed 0
# --ks 5 --nevals 100 --clf logistic_regression \
# --ks 1 5 50 500 -1 --nevals 100 30 10 3 1 --clf nearest_neighbor \
# --input_zca --output_pool 2 \
# --rescale_features --signed_features_if_1D \
