from datetime import datetime
from FedFL import FedFL_strategy, fedlf_client_fn
from feddrop import dropout_strategy, feddrop_client_fn
from cocofl import cocoFL_strategy, cocofl_client_fn
from SLT import SLT_strategy, stl_client_fn
from fjord import fjord_strategy, fjord_client_fn
import flwr as fl
import random

NUM_SIMS = 1
ROUNDS = 500
FF = 0.1
FE = 1
MFC = 10
MEC = 100
MAC = 100

for i in range(NUM_SIMS):
    randseed = random.randint(0, 99999)
    random.seed(randseed)
    test_acc = []
    selected_clients = []
    strategy = SLT_strategy(FF, FE, MFC, MEC, MAC, maxiter=ROUNDS, ACC=test_acc, ClientsSelection=selected_clients)
    fl.simulation.start_simulation(
        client_fn=stl_client_fn,
        num_clients=MAC,
        config=fl.server.ServerConfig(num_rounds=ROUNDS),
        strategy=strategy
    )
    now = datetime.now()
    with open('results/SLT_accuracies_alpha0.1_' + now.strftime("%Y%m%d%H%M") + '.txt', 'w') as fp:
            for item in test_acc:
                # write each item on a new line
                fp.write("%f\n" % item)

for i in range(NUM_SIMS):
    randseed = random.randint(0, 99999)
    random.seed(randseed)
    test_acc = []
    selected_clients = []
    strategy = fjord_strategy(FF, FE, MFC, MEC, MAC, ACC=test_acc, ClientsSelection=selected_clients)
    fl.simulation.start_simulation(
        client_fn=fjord_client_fn,
        num_clients=MAC,
        config=fl.server.ServerConfig(num_rounds=ROUNDS),
        strategy=strategy
    )
    now = datetime.now()
    with open('results/fjord_accuracies_alpha0.1_' + now.strftime("%Y%m%d%H%M") + '.txt', 'w') as fp:
        for item in test_acc:
            # write each item on a new line
            fp.write("%f\n" % item)


for i in range(NUM_SIMS):
    randseed = random.randint(0, 99999)
    random.seed(randseed)
    test_acc = []
    selected_clients = []
    strategy = cocoFL_strategy(FF, FE, MFC, MEC, MAC, ACC=test_acc, ClientsSelection=selected_clients)
    fl.simulation.start_simulation(
        client_fn=cocofl_client_fn,
        num_clients=MAC,
        config=fl.server.ServerConfig(num_rounds=ROUNDS),
        strategy=strategy
    )
    now = datetime.now()
    with open('results/cocoFL_accuracies_alpha0.1_' + now.strftime("%Y%m%d%H%M") + '.txt', 'w') as fp:
            for item in test_acc:
                # write each item on a new line
                fp.write("%f\n" % item)


for i in range(NUM_SIMS):
    randseed = random.randint(0, 99999)
    random.seed(randseed)
    test_acc = []
    selected_clients = []
    strategy = FedFL_strategy(FF, FE, MFC, MEC, MAC, ACC=test_acc, ClientsSelection=selected_clients)
    fl.simulation.start_simulation(
        client_fn=fedlf_client_fn,
        num_clients=MAC,
        config=fl.server.ServerConfig(num_rounds=ROUNDS),
        strategy=strategy
    )
    now = datetime.now()
    with open('results/FedOLF_accuracies_alpha0.1_' + now.strftime("%Y%m%d%H%M") + '.txt', 'w') as fp:
            for item in test_acc:
                # write each item on a new line
                fp.write("%f\n" % item)

for i in range(NUM_SIMS):
    randseed = random.randint(0, 99999)
    random.seed(randseed)
    test_acc = []
    selected_clients = []
    strategy = dropout_strategy(FF, FE, MFC, MEC, MAC, ACC=test_acc, ClientsSelection=selected_clients)
    fl.simulation.start_simulation(
        client_fn=feddrop_client_fn,
        num_clients=MAC,
        config=fl.server.ServerConfig(num_rounds=ROUNDS),
        strategy=strategy
    )
    now = datetime.now()
    with open('results/feddrop_accuracies_alpha0.1_' + now.strftime("%Y%m%d%H%M") + '.txt', 'w') as fp:
        for item in test_acc:
            # write each item on a new line
            fp.write("%f\n" % item)

