# Latent Space Symmetry Discovery (LaLiGAN)

## Setup datasets

### Reaction-Diffusion System
The system is simulated with the Matlab scripts provided in [SINDy Autoencoders](https://github.com/kpchamp/SindyAutoencoders/tree/master/rd_solver).

Running the script `reaction_diffusion.m` should produce the data file `reaction_diffusion.mat`. Then, place it under `./data` in this repository.

### Rotating Object
Generate the renderings of a bookshelf with different orientations:
```
python data_utils/rot_obj.py --num_samples 10000 --name train
python data_utils/rot_obj.py --num_samples 1000 --name test
```

## Experiments

### Reaction-Diffusion System
LaLiGAN Symmetry discovery in 2D latent space:
```
python main.py --config config/rd.cfg
```
LaLiGAN Symmetry discovery in 3D latent space:
```
python main.py --config config/rd_3d.cfg
```
SINDy equation discovery in the LaLiGAN 2D latent space:
```
python main_sindy.py --config config/rd_sindy.cfg
```
SINDy equation discovery in the LaLiGAN 3D latent space:
```
python main_sindy.py --config config/rd_sindy_3d.cfg
```
SINDy Autoencoder equation discovery in the 3D latent space:
```
python main.py --config config/rd_sindyonly.cfg
```

### Nonlinear Pendulum
LaLiGAN Symmetry discovery for nonlinear pendulum:
```
python main.py --config config/pendulum.cfg
```
(Baseline) LieGAN symmetry discovery for nonlinear pendulum:
```
python main.py --config config/pendulum_liegan.cfg
```
SINDy equation discovery in the LaLiGAN latent space:
```
python main_sindy.py --config config/pendulum_sindy.cfg
```
SINDy Autoencoder equation discovery:
```
python main.py --config config/pendulum_sindyae.cfg
```
SINDy equation discovery w/o autoencoder:
```
python main.py --config config/pendulum_sindyonly.cfg
```

### Lotka-Volterra Equations
LaLiGAN Symmetry discovery for Lotka-Volterra system:
```
python main.py --config config/lv.cfg
```
(Baseline) LieGAN symmetry discovery Lotka-Volterra system:
```
python main.py --config config/lv_liegan.cfg
```
SINDy equation discovery in the LaLiGAN latent space:
```
python main_sindy.py --config config/lv_sindy.cfg
```
SINDy Autoencoder equation discovery:
```
python main.py --config config/lv_sindyae.cfg
```
SINDy equation discovery w/o autoencoder:
```
python main.py --config config/lv_sindyonly.cfg
```

### Double Bump World
Learning $\mathrm{SO}(2) \times \mathrm{SO}(2)$ equivariant representation:
```
python main.py --config config/double_bump.cfg
```

### Rotating Object
Learning $\mathrm{SO}(3)$ equivariant representation:
```
python main.py --config config/rs.cfg
```
