def add_model_config(parser):
    parser.add_argument('--model_name', help='gsl model', type=str, default="LLaTA")
    parser.add_argument('--num_layers', help='number of gnn layers', type=int, default=2)
    parser.add_argument('--hidden_dim', help='hidden units', type=int, default=64)
    parser.add_argument('--r', help='symmetric normalized unit', type=float, default=0.5)
    parser.add_argument('--gnn_type', help='gnn model', type=str, default="gcn")
    
    # gat
    parser.add_argument('--num_heads', help='number of attention', type=int, default=8)
    
    # selm
    parser.add_argument('--LLaTA_K', help='height of coding tree', type=int, default=3)
    parser.add_argument('--LLaTA_theta', help='threshold of community size which need to be extended', type=int, default=10)
    parser.add_argument('--LLaTA_r', help='sample rate from code tree', type=int, default=3)
    parser.add_argument('--nei_max', help='max neighbor num for class-score', type=int, default=5)
    parser.add_argument('--LLaTA_epsilon', help='threshold to choose top k neighbor', type=float, default=0.4)