# `CARSO`: *Blending Adversarial Training and Purification Improves Adversarial Robustness*

## Reproducibility requirements

The code has been tested with `Python 3.10.12`, running on `Ubuntu 20.04`. The only system-wide requirements are a `bash` shell and availability of the `curl` command. A working *base* Python installation is also required. Additional dependencies are listed in the `requirements.txt` file, and may be installed by `pip install -r ./requirements.txt`.

In order to fruitfully use *GPU* acceleration, working *kernel-space* *NVIDIA CUDA*-compatible drivers are required (the exact version depending on *PyTorch* compatibility and the specific system in use).

## Datasets, *pre-trained* models

The datasets employed (*CIFAR-10*, *CIFAR-100*) are downloaded automatically by the Python scripts provided. A working Internet connection is required for their download.

The training code requires pre-trained models from *[Wong at al., 2020]*, *[Rebuffi et al., 2021]* and *[Cui et al., 2023]* - obtainable from an `s3` storage bucket (set up *ad hoc* for the sake of reproducibility), by `cd ./models/; bash get_models_train.sh`. Such setup allows reproduction of the training phase described in the paper.

To download the entire set of *pre-trained* models required to reproduce the evaluation phase only (without actually performing the training itself), `cd ./models/; bash get_models_test.sh` is required. Pre-trained models will be downloaded from the same `s3` storage bucket.

## Model training

To reproduce the training phase in its entirety, the following commands are to be issued.

```bash

# Scenario (a)
python -O train_a.py --save_model

# Scenario (b)
python -O train_b.py --save_model

# Scenario (c)
python -O train_c.py --save_model

# Scenario (d)
python -O train_d.py --save_model
```

The `python` command is assumed to be from the environment set up earlier. The *scenarios* referred to mirror the description provided within the paper.  

The `train_c.py` and `train_d.py` scripts, further require execution within a Slurm-scheduled system, requesting 8 tasks in total, and with the availability 8 GPUs in total. The environment variable `WORLD_SIZE=$(($SLURM_NNODES * $SLURM_NTASKS_PER_NODE))` must also be set. 

## Model evaluation

To reproduce the evaluation phase in its entirety, the following commands are to be issued.

```bash

# Scenario (a)
python -O eval_a.py --e2e --explicitly_random
python -O eval_a.py --e2e --explicitly_random --eps 0.9 # Gradient obfuscation test

# Scenario (b)
python -O eval_b.py --e2e --explicitly_random
python -O eval_b.py --e2e --explicitly_random --eps 0.9 # Gradient obfuscation test

# Scenario (c)
python -O eval_c.py --e2e --explicitly_random
python -O eval_c.py --e2e --explicitly_random --eps 0.9 # Gradient obfuscation test

# Scenario (d)
python -O eval_d.py
python -O eval_d.py --eps 0.9 # Gradient obfuscation test
```

The `python` command is assumed to be from the environment set up earlier. The *scenarios* and *attacks* referred to mirror the description provided within the paper.  

The `eval_d.py` script further requires execution within a Slurm-scheduled system. The environment variable `WORLD_SIZE=$(($SLURM_NNODES * $SLURM_NTASKS_PER_NODE))` must also be set.
