#!/bin/bash
# Revised load_env.sh: load environment variables from .env using source

ENV_FILE="${1:-./.env}"
if [ -f "$ENV_FILE" ]; then
  echo "Loading environment variables from $ENV_FILE"
  # Automatically export all variables defined in the env file:
  set -a
  source "$ENV_FILE"
  set +a
  echo "Environment variables loaded successfully"
else
  echo "Error: $ENV_FILE not found"
  exit 1
fi
