from scripts.utils.graph_validation import generate_valid_graph
from scripts.utils.create_graph import generate_random_graph, generate_random_tree


def test_property_status():
    """Test that PropertyStatus enum is working correctly in validation."""

    # Test with a guaranteed TRUE property (trees are connected)
    try:
        tree = generate_valid_graph( # pylint: disable=unused-variable
            generate_random_tree,
            required_properties=["connected"],
            num_nodes=8,
            seed=42,
            debug_mode=True,
        )
        print("✅ Successfully generated a tree with guaranteed 'connected' property")
    except ValueError as e:
        print(f"❌ Failed to generate tree: {e}")

    # Test with a MAYBE property that needs checking
    try:
        connected_graph = generate_valid_graph(# pylint: disable=unused-variable
            generate_random_graph,  # Random graphs might be connected
            required_properties=["cyclic"],
            num_nodes=10,
            seed=41,
            debug_mode=True,
        )
        print("✅ Successfully generated a random graph that is connected")
    except ValueError as e:
        print(f"❌ Failed to generate connected random graph: {e}")

        # Test with a MAYBE property that needs checking
    try:
        connected_graph = generate_valid_graph(
            generate_random_graph,  # Random graphs might be connected
            required_properties=["acyclic"],
            num_nodes=10,
            seed=41,
            debug_mode=True,
        )
        print("✅ Successfully generated a random graph that is connected")
    except ValueError as e:
        print(f"❌ Failed to generate connected random graph: {e}")

    # Test with a FALSE property (should fail immediately)
    try:
        tree_with_cycle = generate_valid_graph(# pylint: disable=unused-variable
            generate_random_tree,  # Trees cannot have cycles
            required_properties=["cyclic"],
            num_nodes=8,
            seed=42,
            debug_mode=True,
        )
        print("❌ Incorrectly generated a tree that is cyclic (impossible)")
    except ValueError as e:
        print(f"✅ Correctly failed with: {e}")


if __name__ == "__main__":
    test_property_status()
