#!/usr/bin/bash

# git lfs install
export HF_ENDPOINT=https://hf-mirror.com

# huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/ bigcode/the-stack

### multi chart
mkdir -p data/chartQA/multi_chart
cd data/chartQA/multi_chart || exit 1

# MultiChartQA
git clone https://github.com/Zivenzhu/Multi-chart-QA.git

# ChartInsights
git clone https://github.com/HKUSTDial/ChartInsights.git

# CharXiv
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/multi_chart/CharXiv princeton-nlp/CharXiv
# git clone https://hf-mirror.com/datasets/princeton-nlp/CharXiv

# DomainCQA
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/multi_chart/AstroChart yangjing0128/AstroChart
# git clone https://hf-mirror.com/datasets/yangjing0128/AstroChart

# SPIQA
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/multi_chart/spiqa google/spiqa
# git clone https://hf-mirror.com/datasets/google/spiqa

# ChartQAPro
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/multi_chart/ChartQAPro ahmed-masry/ChartQAPro
# git clone https://hf-mirror.com/datasets/ahmed-masry/ChartQAPro

# chart-llm
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/multi_chart/chart-llm hyungkwonko/chart-llm
# git clone https://hf-mirror.com/datasets/hyungkwonko/chart-llm
# git clone https://github.com/hyungkwonko/chart-llm

### single chart
mkdir -p data/chartQA/single_chart
mkdir -p data/chartQA/single_chart/ICPR2022
mkdir -p data/chartQA/single_chart/ICDAR2023
mkdir -p data/chartQA/single_chart/CHART_Info2024
cd data/chartQA/single_chart || exit 1

# ChartQA
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/ChartQA ahmed-masry/ChartQA
# git clone https://hf-mirror.com/datasets/ahmed-masry/ChartQA

# PlotQA
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/plot_qa achang/plot_qa
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/cleaned-plotqa-v2 jrc/cleaned-plotqa-v2
# git clone https://hf-mirror.com/datasets/achang/plot_qa
# git clone https://hf-mirror.com/datasets/jrc/cleaned-plotqa-v2

# UniChart
mkdir -p data/chartQA/single_chart/unichart
cd data/chartQA/single_chart/unichart || exit 1
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/unichart/UniChart-pretrain-images ahmed-masry/UniChart-pretrain-images
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/unichart/UniChart-pretrain-images ahmed-masry/UniChart-pretrain-images
# git clone https://hf-mirror.com/datasets/ahmed-masry/UniChart-pretrain-images
# git clone https://hf-mirror.com/datasets/ahmed-masry/unichart-pretrain-data
cd data/chartQA/single_chart || exit 1

# RealCQA
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/RealCQA sal4ahm/RealCQA
# git clone https://hf-mirror.com/datasets/sal4ahm/RealCQA

# ChartAssistant
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/ChartAssistant FanqingM/ChartAssistant
# git clone https://hf-mirror.com/datasets/FanqingM/ChartAssistant

# ChartGemma
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/ChartGemma ahmed-masry/ChartGemma
# git clone https://hf-mirror.com/datasets/ahmed-masry/ChartGemma

# SciGraphQA-295K-train
huggingface-cli download --repo-type dataset --resume-download --cache-dir data/cache --local-dir-use-symlinks False --local-dir data/chartQA/single_chart/SciGraphQA-295K-train alexshengzhili/SciGraphQA-295K-train
# git clone https://hf-mirror.com/datasets/alexshengzhili/SciGraphQA-295K-train
