#!/usr/bin/bash

# if [ -z "$0" ]; then
#     echo "Usage: $0 [path] [port]"
#     echo "Example: $0 label_studio 61113"
#     exit 1
# fi

# LABELSTUDIOPATH=${1:-label_studio}

# PORT=${2:-61131}

# export LABEL_STUDIO_LOCAL_FILES_SERVING_ENABLED=true
# export LABEL_STUDIO_LOCAL_FILES_DOCUMENT_ROOT="data/chartQA/$LABELSTUDIOPATH/data_to_annotate"

# miniforge3/bin/conda run -n chartcoder --live-stream \
#     label-studio start \
#     -db data/chartQA/"$LABELSTUDIOPATH"/db/label_studio.sqlite3 \
#     --data-dir data/chartQA/"$LABELSTUDIOPATH"/data/ \
#     --port "$PORT" \
#     --username admin \
#     --password password


if [ -z "$0" ]; then
    echo "Usage: $0 [path] [port]"
    echo "Example: $0 label_studio 10018"
    exit 1
fi

LABELSTUDIOPATH=${1:-label_studio}

PORT=${2:-10001}

export LABEL_STUDIO_LOCAL_FILES_SERVING_ENABLED=true
export LABEL_STUDIO_LOCAL_FILES_DOCUMENT_ROOT="$LABELSTUDIOPATH/data_to_annotate"
# label_studio/data

miniforge3/bin/conda run -n chartqa --live-stream \
    label-studio start \
    -db "$LABELSTUDIOPATH"/db/label_studio.sqlite3 \
    --data-dir "$LABELSTUDIOPATH"/data/ \
    --port "$PORT" \
    --username admin \
    --password password