#!/usr/bin/bash

# if [ -z "$1" ] || [ -z "$2" ]; then
#     echo "Usage: $0 <input_path> <output_path>"
#     echo "Example: $0 xx/xx.pdf xx/"
# fi

export HF_ENDPOINT=https://hf-mirror.com
export HF_HOME="models/cache"
# mineru-models-download -s huggingface -m all

# Define the source and destination paths
SOURCE_FILE="projects/chartqa/config/mineru.json"
DEST_FILE="$HOME/mineru.json"
# Check if the destination file exists
if [ -f "$DEST_FILE" ]; then
    echo "File $DEST_FILE already exists."
else
    echo "File $DEST_FILE does not exist. Copying from $SOURCE_FILE..."
    # Copy the file
    cp "$SOURCE_FILE" "$DEST_FILE"
    # Check if the copy was successful
    if [ $? -eq 0 ]; then
        echo "File copied successfully."
    else
        echo "Error: Failed to copy the file."
    fi
fi

"$HOME/miniforge3/bin/conda" run -n mineru --live-stream \
    python projects/chartqa/src/mineru/start_mineru.py
