import os, sys

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from utils.agent import CommonAgents
from utils.eval import EVAL

sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))))
from gpt_api.unigpt import GPT


# miniforge3/condabin/conda run -n chartqa --live-stream python project/chartqa/src/evaluation/chartqa/src/eval_closed/eval_double.py
if __name__ == "__main__":
    ### doubao-seed-1-6-250615
    model_name = "doubao-seed-1-6-250615"
    agent = CommonAgents(
        engine=model_name,
        if_reasoner=False,
        stream=False,
        base_url="https://ark.cn-beijing.volces.com/api/v3",
        api_key="",
        if_azure=False,
        if_anthropic=False,
        if_doubao=True,
    )
    eval = EVAL(agent, os.path.join("project/chartqa/result/cot", model_name))
    eval.run_all_prediction(max_workers=10)

    # ### doubao-seed-1-6-thinking-250715
    # model_name = "doubao-seed-1-6-thinking-250715"
    # agent = CommonAgents(
    #     engine=model_name,
    #     if_reasoner=False,
    #     stream=False,
    #     base_url="https://ark.cn-beijing.volces.com/api/v3",
    #     api_key="",
    #     if_azure=False,
    #     if_anthropic=False,
    #     if_doubao=True,
    # )
    # eval = EVAL(agent, os.path.join("project/chartqa/result", model_name))
    # eval.run_all_prediction(max_workers=10)

    # ### doubao-seed-1-6-flash-250715
    # model_name = "doubao-seed-1-6-flash-250715"
    # agent = CommonAgents(
    #     engine=model_name,
    #     if_reasoner=False,
    #     stream=False,
    #     base_url="https://ark.cn-beijing.volces.com/api/v3",
    #     api_key="",
    #     if_azure=False,
    #     if_anthropic=False,
    #     if_doubao=True
    # )
    # eval = EVAL(agent, os.path.join("project/chartqa/result", model_name))
    # eval.run_all_prediction(max_workers=1)
