import os, sys

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from utils.agent import CommonAgents
from utils.eval import EVAL

sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))))
from gpt_api.unigpt import GPT


# miniforge3/condabin/conda run -n chartqa --live-stream python project/chartqa/src/evaluation/chartqa/src/eval_closed/eval_gemini.py
if __name__ == "__main__":
    os.environ["http_proxy"] = "http://127.0.0.1:61110"
    os.environ["https_proxy"] = "http://127.0.0.1:61110"

    ### gemini-2.5-pro
    model_name = "gemini-2.5-pro"
    agent = CommonAgents(
        engine=model_name,
        if_reasoner=False,
        stream=False,
        base_url="https://generativelanguage.googleapis.com/v1beta/openai/",
        api_key="",
    )

    eval = EVAL(agent, os.path.join("project/chartqa/result/cot", model_name))
    eval.run_all_prediction()
    # eval.filter_processed()

    # ### gemini-2.5-flash
    # model_name = "gemini-2.5-flash"
    # agent = CommonAgents(
    #     engine=model_name,
    #     if_reasoner=False,
    #     stream=False,
    #     base_url="https://generativelanguage.googleapis.com/v1beta/openai/",
    #     api_key="",
    # )

    # eval = EVAL(agent, os.path.join("project/chartqa/result", model_name))
    # eval.run_all_prediction()
