import os, sys

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from utils.agent import CommonAgents
from utils.eval import EVAL

sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))))
from gpt_api.unigpt import GPT


# miniforge3/condabin/conda run -n chartqa --live-stream python project/chartqa/src/evaluation/chartqa/src/eval_closed/eval_hunyuan.py
if __name__ == "__main__":
    os.environ["http_proxy"] = "http://127.0.0.1:61110"
    os.environ["https_proxy"] = "http://127.0.0.1:61110"

    ### hunyuan-vision
    model_name = "hunyuan-vision"
    agent = CommonAgents(
        engine=model_name,
        if_reasoner=False,
        stream=False,
        base_url="https://api.hunyuan.cloud.tencent.com/v1",
        api_key="",
        if_azure=False,
        if_anthropic=False,
    )
    eval = EVAL(agent, os.path.join("project/chartqa/result", model_name))
    eval.run_all_prediction(max_workers=1)

    ### hunyuan-turbos-vision
    model_name = "hunyuan-turbos-vision"
    agent = CommonAgents(
        engine=model_name,
        if_reasoner=False,
        stream=False,
        base_url="https://api.hunyuan.cloud.tencent.com/v1",
        api_key="",
        if_azure=False,
        if_anthropic=False,
    )
    eval = EVAL(agent, os.path.join("project/chartqa/result", model_name))
    eval.run_all_prediction(max_workers=1)
