class QAPrompts:

    def __init__(self, if_cot=True) -> None:
        if if_cot:
            self.system_prompt = """You are a helpful assistant for a question-answering task.
Your goal is to answer the question based on the provided contexts.
First, think step-by-step and write down your reasoning process within <reasoning></reasoning> tags. This process should break down how you use the contexts to arrive at the answer.
Finally, provide your final answer within <answer></answer> tags."""
        else:
            self.system_prompt = "You are a helpful assistant. Provide a detailed and helpful response. Always place your final answer within <answer></answer> tags."

    def qa_prompt(self, prompt, contexts: list, question: str) -> str:
        for context in contexts:
            prompt += f"""
Context: <context>{context}</context>

"""
        prompt += f"""
Question: <question>{question}</question>

"""
        return prompt

    def qa_extract(self) -> str:
        prompt = f"""
You will be given a question about some charts. You need to answer this question based on the provided charts as well as its related context. The context corresponding to each chart will be placed within <context></context> tags, and the question to be answered will be placed within <question></question> tags.

Your answer should be a single word, number, or phrase. If the question is unanswerable based on the information in the provided image, your answer should be unanswerable.

Do not generate units. But if numerical units such as million, m, billion, B, or K are required, use the exact notation shown in the chart.  If there are multiple answers, put them in brackets using this format ["Answer1", "Answer2"].

"""
        return prompt

    def qa_multi_choices(self) -> str:
        prompt = f"""
You will be given a multiple-choice question about charts. You need to answer this question based on the provided charts and its related context. The context for each chart will be placed within <context></context> tags, and the question will be placed within <question></question> tags.

Your answer should be the letter of the correct option (e.g., A, B, C, etc.). If the question is unanswerable based on the information in the provided image, your answer should be unanswerable.

"""
        return prompt

    def qa_approximate(self) -> str:
        prompt = f"""
You will be given a numerical question-answering task about charts. You are required to answer this question based on the provided charts and its related context. The context for each chart will be placed within <context></context> tags, and the question will be placed within <question></question> tags.

Your answer should be the most appropriate approximate numerical value. If the question is unanswerable based on the information in the provided image, your answer should be unanswerable.

Do not generate units. But if numerical units such as million, m, billion, B, or K are required, use the exact notation shown in the chart.  If there are multiple answers, put them in brackets using this format ["Answer1", "Answer2"].

"""
        return prompt

    def qa_bool(self) -> str:
        prompt = f"""
You will be given a true/false question about charts. You are required to answer this question based on the provided charts and its related context. The context for each chart will be placed within <context></context> tags, and the question will be placed within <question></question> tags.

Your answer should be either 'true' or 'false'. If the question is unanswerable based on the information in the provided image, your answer should be unanswerable.

"""
        return prompt

    def qa_open_end(self) -> str:
        prompt = f"""
You will be given an open-ended question about charts. You are required to answer this question based on the provided charts and its related context. The context for each chart will be placed within <context></context> tags, and the question will be placed within <question></question> tags.

Your answer should be a logical and well-reasoned explanation that addresses the question. If the question is unanswerable based on the information in the provided image, your answer should be unanswerable.

"""
        return prompt


class EVALPrompts:
    def __init__(self) -> None:
        self.system_prompt = "You are a helpful assistant. You need to compare a given answer with the ground truth to determine if it is correct. Always place your final answer within <answer></answer> tags."

    def eval_prompt(self, prompt, question: str, predict: str, gt: str) -> str:
        prompt += f"""
Question: <question>{question}</question>

"""
        prompt += f"""
Predict Answer: <predict>{predict}</predict>

"""
        prompt += f"""
Ground Truth: <gt>{gt}</gt>

"""
        return prompt

    def eval_extract(self) -> str:
        prompt = f"""
You are required to determine if a predicted answer is correct when compared with the ground truth. The question will be placed within <question></question> tags, predicted answer will be placed within <predict></predict> tags, and the ground truth answer will be placed within <gt></gt> tags.

The predicted answer may contain some thought or reasoning content in addition to the final answer. You must first find the correct answer: a word, phrase, or number within the prediction, and then compare it with the ground truth.

Remember to only respond with 'true' or 'false', and place your judgment within <answer></answer> tags.

"""
        return prompt

    def eval_multi_choices(self) -> str:
        prompt = f"""
You are required to determine if a predicted answer is correct when compared with the ground truth. The question will be placed within <question></question> tags, predicted answer will be placed within <predict></predict> tags, and the ground truth answer will be placed within <gt></gt> tags.

The predicted answer may contain additional content, such as reasoning, besides the final answer. You must first extract the correct answer from within the prediction. The answer should be a single multiple-choice option (e.g., A, B, C, etc.). You should then compare this extracted option with the ground truth.

Remember to only respond with 'true' or 'false', and place your judgment within <answer></answer> tags.

"""
        return prompt

    def eval_approximate(self) -> str:
        prompt = f"""
You are required to determine if a predicted answer is correct when compared with the ground truth. The question will be placed within <question></question> tags, predicted answer will be placed within <predict></predict> tags, and the ground truth answer will be placed within <gt></gt> tags.

The predicted answer may contain additional content, such as reasoning, besides the final answer. You must first extract the correct answer from within the prediction, which should be an estimated numerical value. You should then compare this extracted number with the ground truth.

The predicted numerical value is considered correct if it is within a 5% margin of error relative to the ground truth value.

Remember to only respond with 'true' or 'false', and place your judgment within <answer></answer> tags.

"""
        return prompt

    def eval_bool(self) -> str:
        prompt = f"""
You are required to determine if a predicted answer is correct when compared with the ground truth. The question will be placed within <question></question> tags, predicted answer will be placed within <predict></predict> tags, and the ground truth answer will be placed within <gt></gt> tags.

The predicted answer may contain additional content, such as reasoning, besides the final answer. You must first extract the correct answer from within the prediction. The answer should be a response to a true/false or yes/no type of question (e.g., 'true', 'false', 'yes', 'no').

Remember to only respond with 'true' or 'false', and place your judgment within <answer></answer> tags.

"""
        return prompt

    def eval_open_end(self) -> str:
        prompt = f"""
You are required to determine if a predicted answer is correct when compared with the ground truth. The question will be placed within <question></question> tags, predicted answer will be placed within <predict></predict> tags, and the ground truth answer will be placed within <gt></gt> tags.

The predicted answer may contain additional content, such as reasoning or thought processes, besides the final answer. You must first extract the correct, open-ended response from within the prediction.

You will then need to compare this extracted response with the ground truth to determine if they express the same semantic meaning.

Remember to only respond with 'true' or 'false', and place your judgment within <answer></answer> tags.

"""
        return prompt
